/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.util.ArrayList;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.cursor.DateCube;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import testutil.BaseTestCase;

public class DateTimeCursorTest
extends BaseTestCase {
    private Scriptable scope;
    private DataEngineImpl de;

    protected void setUp() throws Exception {
        super.setUp();
        this.scope = new ImporterTopLevel();
        DataEngineContext context = DataEngineContext.newInstance((int)3, (Scriptable)this.scope, null, null);
        context.setTmpdir(DateTimeCursorTest.getTempDir());
        this.de = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        DateCube cube = new DateCube();
        cube.createCube(this.de);
    }

    protected void tearDown() throws Exception {
        if (this.de != null) {
            this.de.shutdown();
            this.de = null;
        }
    }

    public void testMirrorOnYearDimension() throws DataException {
        ICubeQueryDefinition cqd = this.createMirroredQueryDefinition("level12");
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign());
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level11");
        rowEdgeBindingNames.add("level12");
        rowEdgeBindingNames.add("level13");
        rowEdgeBindingNames.add("level14");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level21");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        try {
            this.testOut.print(new CubeUtility().printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, null, null, null, null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            DateTimeCursorTest.fail((String)"fail to get here!");
        }
    }

    public void testMirrorOnQuarterDimension() throws DataException {
        ICubeQueryDefinition cqd = this.createMirroredQueryDefinition("level13");
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign());
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level11");
        rowEdgeBindingNames.add("level12");
        rowEdgeBindingNames.add("level13");
        rowEdgeBindingNames.add("level14");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level21");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        try {
            this.testOut.print(new CubeUtility().printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, null, null, null, null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            DateTimeCursorTest.fail((String)"fail to get here!");
        }
    }

    public void testMirrorOnMonthDimension() throws DataException {
        ICubeQueryDefinition cqd = this.createMirroredQueryDefinition("level14");
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign());
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level11");
        rowEdgeBindingNames.add("level12");
        rowEdgeBindingNames.add("level13");
        rowEdgeBindingNames.add("level14");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level21");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        try {
            this.testOut.print(new CubeUtility().printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, null, null, null, null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            DateTimeCursorTest.fail((String)"fail to get here!");
        }
    }

    ICubeQueryDefinition createMirroredQueryDefinition(String mirrorLevelName) {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        cqd.createMeasure("measure1");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        ILevelDefinition mirrorlevel = null;
        int i = 0;
        while (i < dateHier.getLevels().size()) {
            if (((ILevelDefinition)dateHier.getLevels().get(i)).getName().equals(mirrorLevelName)) {
                mirrorlevel = (ILevelDefinition)dateHier.getLevels().get(i);
            }
            ++i;
        }
        columnEdge.setMirrorStartingLevel(mirrorlevel);
        return cqd;
    }
}

