/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.util.ArrayList;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import testutil.BaseTestCase;

public class MirrorCursorModelTest
extends BaseTestCase {
    private Scriptable scope;
    private DataEngineImpl de;
    private CubeUtility creator;

    protected void setUp() throws Exception {
        super.setUp();
        this.scope = new ImporterTopLevel();
        DataEngineContext context = DataEngineContext.newInstance((int)3, (Scriptable)this.scope, null, null);
        context.setTmpdir(MirrorCursorModelTest.getTempDir());
        this.de = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.creator = new CubeUtility();
        this.creator.createCube(this.de);
        this.creator.createCube1(this.de);
    }

    protected void tearDown() throws Exception {
        if (this.de != null) {
            this.de.shutdown();
            this.de = null;
        }
    }

    public void testCursorModel1() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createMirroredQueryDefinition("cube", true);
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign());
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            MirrorCursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorModelNoBreakHierarchy() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createMirroredQueryDefinition("timeCube", false);
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign());
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            MirrorCursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorOnCountry() throws OLAPException, BirtException {
        ICubeQueryDefinition cqd = this.creator.createMirroredQueryDefinition("cube", true);
        Binding rowGrandTotal = new Binding("countryGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign());
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level21");
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> grandBindingNames = new ArrayList<String>();
        grandBindingNames.add("countryGrandTotal");
        try {
            this.testOut.print(this.creator.printCubeAlongEdge(dataCursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, null, null, null, grandBindingNames));
            this.checkOutputFile();
        }
        catch (Exception exception) {
            MirrorCursorModelTest.fail((String)"fail to get here!");
        }
    }

    public void testCursorOnPageEdge() throws Exception {
        ICubeQueryDefinition cqd = this.creator.createMirroredQueryDefinitionWithPage();
        Binding rowGrandTotal = new Binding("rowGrandTotal");
        rowGrandTotal.setAggrFunction("SUM");
        rowGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        rowGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        rowGrandTotal.addAggregateOn("dimension[\"dimension6\"][\"level22\"]");
        Binding columnGrandTotal = new Binding("columnGrandTotal");
        columnGrandTotal.setAggrFunction("AVE");
        columnGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        columnGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension3\"][\"level13\"]");
        columnGrandTotal.addAggregateOn("dimension[\"dimension4\"][\"level14\"]");
        Binding totalGrandTotal = new Binding("totalGrandTotal");
        totalGrandTotal.setAggrFunction("SUM");
        totalGrandTotal.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        totalGrandTotal.addAggregateOn("dimension[\"dimension5\"][\"level21\"]");
        cqd.addBinding((IBinding)rowGrandTotal);
        cqd.addBinding((IBinding)columnGrandTotal);
        cqd.addBinding((IBinding)totalGrandTotal);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign());
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("level11");
        columnEdgeBindingNames.add("level12");
        columnEdgeBindingNames.add("level13");
        columnEdgeBindingNames.add("level14");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("level22");
        ArrayList<String> measureBindingNames = new ArrayList<String>();
        measureBindingNames.add("measure1");
        ArrayList<String> rowGrandTotalNames = new ArrayList<String>();
        rowGrandTotalNames.add("rowGrandTotal");
        ArrayList<String> pageBindingNames = new ArrayList<String>();
        pageBindingNames.add("level21");
        this.testOut.print(this.creator.printCubeAlongPageEdge(dataCursor, pageBindingNames, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotalNames, "columnGrandTotal", "totalGrandTotal", null));
        this.checkOutputFile();
    }
}

