/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.FourLevelDataset;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.OneLevelDataset;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.ThreeLevelDataset;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;

public class DimensionTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDimensionCreateAndFind() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreate(documentManager);
        this.testDimensionFind(documentManager);
        documentManager.close();
    }

    private void testDimensionCreate(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        ILevelDefn[] levelDefs = new ILevelDefn[1];
        String[] attrs = new String[]{"Name", "Age"};
        levelDefs[0] = new LevelDefinition("student", new String[]{"ID"}, attrs);
        IDimension dimension = DimensionFactory.createDimension((String)"student", (IDocumentManager)documentManager, (IDatasetIterator)new OneLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"student");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"student");
        Dimension realDimension = (Dimension)dimension;
        int i = 0;
        while (i < OneLevelDataset.IDCol.length) {
            IndexKey indexKey = realDimension.findFirst((Level)level[0], new Object[]{new Integer(OneLevelDataset.IDCol[i])});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(OneLevelDataset.IDCol[i]));
            DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)i);
            Member levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(OneLevelDataset.IDCol[i]));
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[0], (Object)OneLevelDataset.NameCol[i]);
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[1], (Object)OneLevelDataset.AgeCol[i]);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(OneLevelDataset.IDCol[i]));
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[0], (Object)OneLevelDataset.NameCol[i]);
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[1], (Object)OneLevelDataset.AgeCol[i]);
            ++i;
        }
    }

    private void testDimensionFind(IDocumentManager documentManager) throws DataException, IOException {
        IDimension dimension = DimensionFactory.loadDimension((String)"student", (IDocumentManager)documentManager);
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"student");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"student");
        Dimension realDimension = (Dimension)dimension;
        int i = 0;
        while (i < OneLevelDataset.IDCol.length) {
            IndexKey indexKey = realDimension.findFirst((Level)level[0], new Object[]{new Integer(OneLevelDataset.IDCol[i])});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(OneLevelDataset.IDCol[i]));
            DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)i);
            Member levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(OneLevelDataset.IDCol[i]));
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[0], (Object)OneLevelDataset.NameCol[i]);
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[1], (Object)OneLevelDataset.AgeCol[i]);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(OneLevelDataset.IDCol[i]));
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[0], (Object)OneLevelDataset.NameCol[i]);
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[1], (Object)OneLevelDataset.AgeCol[i]);
            ++i;
        }
    }

    public void testDimensionCreateAndFind1() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind1(documentManager);
        documentManager.close();
    }

    private void testDimensionCreateAndFind1(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Member levelMember;
        IndexKey indexKey;
        int memeberCount = 10000;
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("student", new String[]{"ID"}, null)};
        String[] levelNames = new String[]{"ID"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        Object[] IDs = new String[memeberCount];
        int i = 0;
        while (i < memeberCount) {
            IDs[i] = String.valueOf(i);
            ++i;
        }
        Arrays.sort(IDs);
        iterator.setLevelMember(0, IDs);
        IDimension dimension = DimensionFactory.createDimension((String)"student", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"student");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"student");
        Dimension realDimension = (Dimension)dimension;
        int i2 = 0;
        while (i2 < memeberCount) {
            indexKey = realDimension.findFirst((Level)level[0], new Object[]{IDs[i2]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)IDs[i2]);
            DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)i2);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)IDs[i2]);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)IDs[i2]);
            ++i2;
        }
        dimension = DimensionFactory.loadDimension((String)"student", (IDocumentManager)documentManager);
        hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"student");
        level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"student");
        realDimension = (Dimension)dimension;
        i2 = 0;
        while (i2 < memeberCount) {
            indexKey = realDimension.findFirst((Level)level[0], new Object[]{IDs[i2]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)IDs[i2]);
            DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)i2);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)IDs[i2]);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)IDs[i2]);
            ++i2;
        }
    }

    public void testDimensionCreateAndFind2() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreate2(documentManager);
        this.testDimensionFind2(documentManager);
        documentManager.close();
    }

    private void testDimensionCreate2(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        ILevelDefn[] levelDefs = new ILevelDefn[3];
        String[] attrs = new String[]{"level3Attribute"};
        levelDefs[0] = new LevelDefinition("level1", new String[]{"level1"}, null);
        levelDefs[1] = new LevelDefinition("level2", new String[]{"level2"}, null);
        levelDefs[2] = new LevelDefinition("level3", new String[]{"level3"}, attrs);
        IDimension dimension = DimensionFactory.createDimension((String)"three", (IDocumentManager)documentManager, (IDatasetIterator)new ThreeLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"level1");
        DimensionTest.assertEquals((int)level[0].getKeyDataType("level1"), (int)5);
        DimensionTest.assertEquals((String)level[1].getName(), (String)"level2");
        DimensionTest.assertEquals((int)level[1].getKeyDataType("level2"), (int)5);
        DimensionTest.assertEquals((String)level[2].getName(), (String)"level3");
        DimensionTest.assertEquals((int)level[2].getKeyDataType("level3"), (int)5);
        Dimension realDimension = (Dimension)dimension;
        int i = 0;
        while (i < ThreeLevelDataset.Level1Col.length) {
            System.out.println(i);
            IndexKey indexKey = realDimension.findFirst((Level)level[0], new Object[]{ThreeLevelDataset.Level1Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            if (i < 5) {
                DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)0);
            }
            if (i >= 5 && i < 12) {
                DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)5);
            }
            if (i >= 12) {
                DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)12);
            }
            Member levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            indexKey = realDimension.findFirst((Level)level[1], new Object[]{ThreeLevelDataset.Level2Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[1];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            indexKey = realDimension.findFirst((Level)level[2], new Object[]{ThreeLevelDataset.Level3Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)i);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[2];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            ++i;
        }
    }

    private void testDimensionFind2(IDocumentManager documentManager) throws DataException, IOException {
        System.out.println("load starting...");
        IDimension dimension = DimensionFactory.loadDimension((String)"three", (IDocumentManager)documentManager);
        System.out.println("load end...");
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"level1");
        DimensionTest.assertEquals((int)level[0].getKeyDataType("level1"), (int)5);
        DimensionTest.assertEquals((String)level[1].getName(), (String)"level2");
        DimensionTest.assertEquals((int)level[1].getKeyDataType("level2"), (int)5);
        DimensionTest.assertEquals((String)level[2].getName(), (String)"level3");
        DimensionTest.assertEquals((int)level[2].getKeyDataType("level3"), (int)5);
        Dimension realDimension = (Dimension)dimension;
        int i = 0;
        while (i < ThreeLevelDataset.Level1Col.length) {
            IndexKey indexKey = realDimension.findFirst((Level)level[0], new Object[]{ThreeLevelDataset.Level1Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            if (i < 5) {
                DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)0);
            }
            if (i >= 5 && i < 12) {
                DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)5);
            }
            if (i >= 12) {
                DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)12);
            }
            Member levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            indexKey = realDimension.findFirst((Level)level[1], new Object[]{ThreeLevelDataset.Level2Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[1];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            indexKey = realDimension.findFirst((Level)level[2], new Object[]{ThreeLevelDataset.Level3Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)i);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[2];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            ++i;
        }
    }

    public void testDimensionCreateAndFind3() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreate3(documentManager);
        this.testDimensionFind3(documentManager);
        documentManager.close();
    }

    private void testDimensionCreate3(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        ILevelDefn[] levelDefs = new ILevelDefn[3];
        String[] attrs = new String[]{"level3Attribute"};
        levelDefs[0] = new LevelDefinition("level1", new String[]{"level1"}, null);
        levelDefs[1] = new LevelDefinition("level2", new String[]{"level2"}, null);
        levelDefs[2] = new LevelDefinition("level3", new String[]{"level3"}, attrs);
        IDimension dimension = DimensionFactory.createDimension((String)"three", (IDocumentManager)documentManager, (IDatasetIterator)new ThreeLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        ILevel[] level = hierarchy.getLevels();
        Dimension realDimension = (Dimension)dimension;
        int i = 0;
        while (i < ThreeLevelDataset.Level1Col.length) {
            IndexKey indexKey = realDimension.findFirst((Level)level[0], new Object[]{ThreeLevelDataset.Level1Col[i]});
            Member levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            indexKey = realDimension.findFirst((Level)level[1], new Object[]{ThreeLevelDataset.Level2Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[1];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            indexKey = realDimension.findFirst((Level)level[2], new Object[]{ThreeLevelDataset.Level3Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)i);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[2];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((int)levelMember.getAttributes().length, (int)1);
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[0], (Object)new Integer(ThreeLevelDataset.Level3AttributeCol[i]));
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((int)levelMember.getAttributes().length, (int)1);
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[0], (Object)new Integer(ThreeLevelDataset.Level3AttributeCol[i]));
            ++i;
        }
    }

    private void testDimensionFind3(IDocumentManager documentManager) throws DataException, IOException {
        System.out.println("load starting...");
        IDimension dimension = DimensionFactory.loadDimension((String)"three", (IDocumentManager)documentManager);
        System.out.println("load end...");
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"level1");
        DimensionTest.assertEquals((int)level[0].getKeyDataType("level1"), (int)5);
        DimensionTest.assertEquals((String)level[1].getName(), (String)"level2");
        DimensionTest.assertEquals((int)level[1].getKeyDataType("level2"), (int)5);
        DimensionTest.assertEquals((String)level[2].getName(), (String)"level3");
        DimensionTest.assertEquals((int)level[2].getKeyDataType("level3"), (int)5);
        Dimension realDimension = (Dimension)dimension;
        int i = 0;
        while (i < ThreeLevelDataset.Level1Col.length) {
            IndexKey indexKey = realDimension.findFirst((Level)level[0], new Object[]{ThreeLevelDataset.Level1Col[i]});
            Member levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level1Col[i]);
            indexKey = realDimension.findFirst((Level)level[1], new Object[]{ThreeLevelDataset.Level2Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[1];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level2Col[i]);
            DimensionTest.assertTrue((levelMember.getAttributes() == null ? 1 : 0) != 0);
            indexKey = realDimension.findFirst((Level)level[2], new Object[]{ThreeLevelDataset.Level3Col[i]});
            DimensionTest.assertEquals((Object)indexKey.getKey()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((int)indexKey.getDimensionPos(), (int)i);
            levelMember = realDimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[2];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((int)levelMember.getAttributes().length, (int)1);
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[0], (Object)new Integer(ThreeLevelDataset.Level3AttributeCol[i]));
            levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
            DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)ThreeLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((int)levelMember.getAttributes().length, (int)1);
            DimensionTest.assertEquals((Object)levelMember.getAttributes()[0], (Object)new Integer(ThreeLevelDataset.Level3AttributeCol[i]));
            ++i;
        }
    }

    public void testDimensionCreateAndFind4() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind4(documentManager);
        documentManager.close();
    }

    private void testDimensionCreateAndFind4(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        ILevelDefn[] levelDefs = new ILevelDefn[3];
        String[] attrs = new String[]{"level3Attribute"};
        levelDefs[0] = new LevelDefinition("level1", new String[]{"level1"}, null);
        levelDefs[1] = new LevelDefinition("level2", new String[]{"level2"}, null);
        levelDefs[2] = new LevelDefinition("level3", new String[]{"level3"}, attrs);
        IDimension dimension = DimensionFactory.createDimension((String)"three", (IDocumentManager)documentManager, (IDatasetIterator)new ThreeLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        ILevel[] level = hierarchy.getLevels();
        Dimension realDimension = (Dimension)dimension;
        IndexKey indexKey = realDimension.findFirst((Level)level[0], new Object[]{"1"});
        Member levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"1");
        indexKey = realDimension.findFirst((Level)level[0], new Object[]{"2"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"2");
        indexKey = realDimension.findFirst((Level)level[0], new Object[]{"3"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"3");
        indexKey = realDimension.findFirst((Level)level[1], new Object[]{"11"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"11");
        indexKey = realDimension.findFirst((Level)level[1], new Object[]{"31"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"31");
        indexKey = realDimension.findFirst((Level)level[1], new Object[]{"32"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"32");
        indexKey = realDimension.findFirst((Level)level[2], new Object[]{"111"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"111");
        indexKey = realDimension.findFirst((Level)level[2], new Object[]{"311"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"311");
        indexKey = realDimension.findFirst((Level)level[2], new Object[]{"321"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"321");
        System.out.println("load starting...");
        dimension = DimensionFactory.loadDimension((String)"three", (IDocumentManager)documentManager);
        System.out.println("load end...");
        hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"three");
        level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"level1");
        DimensionTest.assertEquals((int)level[0].getKeyDataType("level1"), (int)5);
        DimensionTest.assertEquals((String)level[1].getName(), (String)"level2");
        DimensionTest.assertEquals((int)level[1].getKeyDataType("level2"), (int)5);
        DimensionTest.assertEquals((String)level[2].getName(), (String)"level3");
        DimensionTest.assertEquals((int)level[2].getKeyDataType("level3"), (int)5);
        realDimension = (Dimension)dimension;
    }

    public void testDimensionCreateAndFind5() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreate5(documentManager);
        this.testDimensionFind5(documentManager);
        documentManager.close();
    }

    private void testDimensionCreate5(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level1", new String[]{"level1"}, null), new LevelDefinition("level2", new String[]{"level2"}, null), new LevelDefinition("level3", new String[]{"level3"}, null), new LevelDefinition("level4", new String[]{"level4"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"four", (IDocumentManager)documentManager, (IDatasetIterator)new FourLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        ILevel[] level = hierarchy.getLevels();
        Dimension realDimension = (Dimension)dimension;
        IndexKey indexKey = realDimension.findFirst((Level)level[0], new Object[]{"1"});
        Member levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"1");
        indexKey = realDimension.findFirst((Level)level[0], new Object[]{"2"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"2");
        indexKey = realDimension.findFirst((Level)level[0], new Object[]{"3"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"3");
        indexKey = realDimension.findFirst((Level)level[1], new Object[]{"11"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"11");
        indexKey = realDimension.findFirst((Level)level[1], new Object[]{"31"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"31");
        indexKey = realDimension.findFirst((Level)level[1], new Object[]{"32"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"32");
        indexKey = realDimension.findFirst((Level)level[2], new Object[]{"111"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"111");
        indexKey = realDimension.findFirst((Level)level[2], new Object[]{"311"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"311");
        indexKey = realDimension.findFirst((Level)level[2], new Object[]{"321"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"321");
        indexKey = realDimension.findFirst((Level)level[3], new Object[]{"1111"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[3];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"1111");
        indexKey = realDimension.findFirst((Level)level[3], new Object[]{"3111"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[3];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"3111");
        indexKey = realDimension.findFirst((Level)level[3], new Object[]{"3211"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[3];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"3211");
        indexKey = realDimension.findFirst((Level)level[3], new Object[]{"3212"});
        levelMember = realDimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[3];
        DimensionTest.assertEquals((Object)levelMember.getKeyValues()[0], (Object)"3212");
    }

    private void testDimensionFind5(IDocumentManager documentManager) throws DataException, IOException {
        System.out.println("load starting...");
        IDimension dimension = DimensionFactory.loadDimension((String)"four", (IDocumentManager)documentManager);
        System.out.println("load end...");
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        level = hierarchy.getLevels();
        DimensionTest.assertEquals((String)level[0].getName(), (String)"level1");
        DimensionTest.assertEquals((int)level[0].getKeyDataType("level1"), (int)5);
        DimensionTest.assertEquals((String)level[1].getName(), (String)"level2");
        DimensionTest.assertEquals((int)level[1].getKeyDataType("level2"), (int)5);
        DimensionTest.assertEquals((String)level[2].getName(), (String)"level3");
        DimensionTest.assertEquals((int)level[2].getKeyDataType("level3"), (int)5);
        DimensionTest.assertEquals((String)level[3].getName(), (String)"level4");
        DimensionTest.assertEquals((int)level[3].getKeyDataType("level4"), (int)5);
    }

    public void testDimensionCreateAndFind6() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind6(documentManager);
        documentManager.close();
    }

    private void testDimensionCreateAndFind6(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level1", new String[]{"level1"}, null), new LevelDefinition("level2", new String[]{"level2"}, null), new LevelDefinition("level3", new String[]{"level3"}, null), new LevelDefinition("level4", new String[]{"level4"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"four", (IDocumentManager)documentManager, (IDatasetIterator)new FourLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        ILevel[] levels = hierarchy.getLevels();
        Dimension realDimension = (Dimension)dimension;
        Level[] levelsForFilter = new Level[]{(Level)levels[1], (Level)levels[3]};
        ISelection[][] filters = new ISelection[][]{new ISelection[2], new ISelection[2]};
        Object[][] selectedObjects = new Object[][]{{"22"}, {"32"}};
        filters[0][0] = SelectionFactory.createMutiKeySelection((Object[][])selectedObjects);
        filters[0][1] = SelectionFactory.createRangeSelection((Object[])new Object[]{"21"}, (Object[])new Object[]{"23"}, (boolean)true, (boolean)true);
        selectedObjects = new String[4][];
        selectedObjects[0] = new String[1];
        selectedObjects[0][0] = "3111";
        selectedObjects[1] = new String[1];
        selectedObjects[1][0] = "3211";
        selectedObjects[2] = new String[1];
        selectedObjects[2][0] = "2221";
        selectedObjects[3] = new String[1];
        selectedObjects[3][0] = "2211";
        filters[1][0] = SelectionFactory.createMutiKeySelection((Object[][])selectedObjects);
        filters[1][1] = SelectionFactory.createRangeSelection((Object[])new Object[]{"2211"}, (Object[])new Object[]{"2231"}, (boolean)true, (boolean)true);
        IDiskArray findResult = realDimension.find(levelsForFilter, (ISelection[][])filters);
        DimensionTest.assertEquals((Object)findResult.get(0), (Object)new Integer(7));
        DimensionTest.assertEquals((Object)findResult.get(1), (Object)new Integer(8));
        DimensionTest.assertEquals((Object)findResult.get(2), (Object)new Integer(9));
        DimensionTest.assertEquals((Object)findResult.get(3), (Object)new Integer(13));
        System.out.println("load starting...");
        dimension = DimensionFactory.loadDimension((String)"four", (IDocumentManager)documentManager);
        System.out.println("load end...");
        hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        levels = hierarchy.getLevels();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        levels = hierarchy.getLevels();
        DimensionTest.assertEquals((String)levels[0].getName(), (String)"level1");
        DimensionTest.assertEquals((int)levels[0].getKeyDataType("level1"), (int)5);
        DimensionTest.assertEquals((String)levels[1].getName(), (String)"level2");
        DimensionTest.assertEquals((int)levels[1].getKeyDataType("level2"), (int)5);
        DimensionTest.assertEquals((String)levels[2].getName(), (String)"level3");
        DimensionTest.assertEquals((int)levels[2].getKeyDataType("level3"), (int)5);
        realDimension = (Dimension)dimension;
        findResult = realDimension.find(levelsForFilter, (ISelection[][])filters);
        DimensionTest.assertEquals((Object)findResult.get(0), (Object)new Integer(7));
        DimensionTest.assertEquals((Object)findResult.get(1), (Object)new Integer(8));
        DimensionTest.assertEquals((Object)findResult.get(2), (Object)new Integer(9));
        DimensionTest.assertEquals((Object)findResult.get(3), (Object)new Integer(13));
    }

    public void testDimensionCreateAndFind7() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind7(documentManager);
        documentManager.close();
    }

    private void testDimensionCreateAndFind7(IDocumentManager documentManager) throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level1", new String[]{"level1"}, null), new LevelDefinition("level2", new String[]{"level2"}, null), new LevelDefinition("level3", new String[]{"level3"}, null), new LevelDefinition("level4", new String[]{"level4"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"four", (IDocumentManager)documentManager, (IDatasetIterator)new FourLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        Dimension realDimension = (Dimension)dimension;
        BufferedPrimitiveDiskArray indexArray = new BufferedPrimitiveDiskArray();
        indexArray.add((Object)new Integer(2));
        indexArray.add((Object)new Integer(5));
        indexArray.add((Object)new Integer(8));
        indexArray.add((Object)new Integer(9));
        indexArray.add((Object)new Integer(10));
        indexArray.add((Object)new Integer(11));
        indexArray.add((Object)new Integer(14));
        IDiskArray result = realDimension.getDimensionRowByPositions((IDiskArray)indexArray, new StopSign());
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(0)).getMembers()[3].getKeyValues()[0], (Object)"1131");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(1)).getMembers()[3].getKeyValues()[0], (Object)"2111");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(2)).getMembers()[3].getKeyValues()[0], (Object)"2221");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(3)).getMembers()[3].getKeyValues()[0], (Object)"2231");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(4)).getMembers()[3].getKeyValues()[0], (Object)"2311");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(5)).getMembers()[3].getKeyValues()[0], (Object)"2321");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(6)).getMembers()[3].getKeyValues()[0], (Object)"3212");
    }

    public void testDimensionCreateAndFind8() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind8(documentManager);
        documentManager.close();
    }

    private void testDimensionCreateAndFind8(IDocumentManager documentManager) throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level1", new String[]{"level1"}, null), new LevelDefinition("level2", new String[]{"level2"}, null), new LevelDefinition("level3", new String[]{"level3"}, null), new LevelDefinition("level4", new String[]{"level4"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"four", (IDocumentManager)documentManager, (IDatasetIterator)new FourLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        DimensionTest.assertEquals((boolean)dimension.isTime(), (boolean)false);
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        Dimension realDimension = (Dimension)dimension;
        BufferedPrimitiveDiskArray indexArray = new BufferedPrimitiveDiskArray();
        indexArray.add((Object)new Integer(2));
        indexArray.add((Object)new Integer(5));
        indexArray.add((Object)new Integer(8));
        indexArray.add((Object)new Integer(9));
        indexArray.add((Object)new Integer(10));
        indexArray.add((Object)new Integer(11));
        indexArray.add((Object)new Integer(14));
        IDiskArray result = realDimension.getDimensionRowByPositions((IDiskArray)indexArray, new StopSign());
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(0)).getMembers()[2].getKeyValues()[0], (Object)"113");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(1)).getMembers()[2].getKeyValues()[0], (Object)"211");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(2)).getMembers()[2].getKeyValues()[0], (Object)"222");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(3)).getMembers()[2].getKeyValues()[0], (Object)"223");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(4)).getMembers()[2].getKeyValues()[0], (Object)"231");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(5)).getMembers()[2].getKeyValues()[0], (Object)"232");
        DimensionTest.assertEquals((Object)((DimensionRow)result.get(6)).getMembers()[2].getKeyValues()[0], (Object)"321");
    }

    public void testDimensionGetAll() throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level1", new String[]{"level1"}, null), new LevelDefinition("level2", new String[]{"level2"}, null), new LevelDefinition("level3", new String[]{"level3"}, null), new LevelDefinition("level4", new String[]{"level4"}, null)};
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        IDimension dimension = DimensionFactory.createDimension((String)"four", (IDocumentManager)documentManager, (IDatasetIterator)new FourLevelDataset(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        DimensionTest.assertEquals((boolean)dimension.isTime(), (boolean)false);
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest.assertEquals((String)hierarchy.getName(), (String)"four");
        Dimension realDimension = (Dimension)dimension;
        IDiskArray result = realDimension.getAllRows(new StopSign());
        int i = 0;
        while (i < result.size()) {
            DimensionRow dimRow = (DimensionRow)result.get(i);
            DimensionTest.assertEquals((Object)dimRow.getMembers()[0].getKeyValues()[0], (Object)FourLevelDataset.Level1Col[i]);
            DimensionTest.assertEquals((Object)dimRow.getMembers()[1].getKeyValues()[0], (Object)FourLevelDataset.Level2Col[i]);
            DimensionTest.assertEquals((Object)dimRow.getMembers()[2].getKeyValues()[0], (Object)FourLevelDataset.Level3Col[i]);
            DimensionTest.assertEquals((Object)dimRow.getMembers()[3].getKeyValues()[0], (Object)FourLevelDataset.Level4Col[i]);
            ++i;
        }
        documentManager.close();
    }
}

