/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dataset1;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dataset2;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dataset3;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;

public class DimensionTest2
extends TestCase {
    private DimLevel dimLevel12;
    private DimLevel dimLevel11;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDimensionCreateAndFind() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind(documentManager);
        documentManager.close();
    }

    private void testDimensionCreateAndFind(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Member levelMember;
        IndexKey indexKey;
        Dimension dimension = this.createDimension(documentManager);
        ILevel[] level = dimension.getHierarchy().getLevels();
        IDiskArray indexKeys = dimension.find((Level)level[0], new Object[]{new Integer(1)});
        DimensionTest2.assertEquals((int)indexKeys.size(), (int)4);
        int i = 0;
        while (i < 4) {
            indexKey = (IndexKey)indexKeys.get(i);
            DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
            DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)i);
            levelMember = dimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
            levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
            ++i;
        }
        dimension = (Dimension)DimensionFactory.loadDimension((String)"student", (IDocumentManager)documentManager);
        indexKeys = dimension.find((Level)level[1], new Object[]{new Integer(1)});
        DimensionTest2.assertEquals((int)indexKeys.size(), (int)4);
        indexKey = (IndexKey)indexKeys.get(0);
        DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)0);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
        indexKey = (IndexKey)indexKeys.get(1);
        DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)1);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
        indexKey = (IndexKey)indexKeys.get(2);
        DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)4);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
        indexKey = (IndexKey)indexKeys.get(3);
        DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)5);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
    }

    private void testDimensionCreateAndFind2(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Member levelMember;
        IndexKey indexKey;
        Dimension dimension = this.createDimension2(documentManager);
        ILevel[] level = dimension.getHierarchy().getLevels();
        IDiskArray indexKeys = dimension.find((Level)level[0], new Object[]{new Integer(1)});
        DimensionTest2.assertEquals((int)indexKeys.size(), (int)4);
        int i = 0;
        while (i < 4) {
            indexKey = (IndexKey)indexKeys.get(i);
            DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
            DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)i);
            levelMember = dimension.getRowByPosition(indexKey.getDimensionPos()).getMembers()[0];
            DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
            levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[0];
            DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
            ++i;
        }
        dimension = (Dimension)DimensionFactory.loadDimension((String)"dataset2", (IDocumentManager)documentManager);
        indexKeys = dimension.find((Level)level[1], new Object[]{new Date(1L)});
        DimensionTest2.assertEquals((int)indexKeys.size(), (int)4);
        indexKey = (IndexKey)indexKeys.get(0);
        DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Date(1L));
        DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)0);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Date(1L));
        indexKey = (IndexKey)indexKeys.get(1);
        DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Date(1L));
        DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)1);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Date(1L));
        indexKey = (IndexKey)indexKeys.get(2);
        DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Date(1L));
        DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)4);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Date(1L));
        indexKey = (IndexKey)indexKeys.get(3);
        DimensionTest2.assertEquals((Object)indexKey.getKey()[0], (Object)new Date(1L));
        DimensionTest2.assertEquals((int)indexKey.getDimensionPos(), (int)5);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[1];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Date(1L));
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()).getMembers()[2];
        DimensionTest2.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Time(6L));
    }

    public void testDimensionCreateAndFind2() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind2(documentManager);
        documentManager.close();
    }

    public void testDimensionCreateAndFind3() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        try {
            this.testDimensionCreateAndFind3(documentManager);
            DimensionTest2.fail((String)"DataException should be thrown!");
        }
        catch (DataException dataException) {}
        documentManager.close();
    }

    private void testDimensionCreateAndFind3(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        this.createDimension3(documentManager);
    }

    public void testDimensionIterator() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionIterator(documentManager);
        documentManager.close();
    }

    private void testDimensionIterator(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Dimension dimension = this.createDimension(documentManager);
        ILevel[] level = dimension.getHierarchy().getLevels();
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(2)}, (boolean)true, (boolean)false);
        Level[] findLevel = new Level[]{(Level)level[1]};
        IDiskArray positionArray = dimension.find(findLevel, filter);
        DimensionTest2.assertEquals((int)positionArray.size(), (int)4);
        DimensionResultIterator dimesionResultSet = new DimensionResultIterator(dimension, positionArray, new StopSign());
        this.dimLevel11 = new DimLevel(dimension.getName(), "l1");
        this.dimLevel12 = new DimLevel(dimension.getName(), "l2");
        DimensionTest2.assertEquals((int)dimesionResultSet.getLevelIndex(this.dimLevel12.getLevelName()), (int)1);
        DimensionTest2.assertEquals((int)dimesionResultSet.getLevelIndex(this.dimLevel11.getLevelName()), (int)0);
        DimensionTest2.assertEquals((int)dimesionResultSet.getLevelKeyDataType(this.dimLevel12.getLevelName())[0], (int)2);
        DimensionTest2.assertEquals((int)dimesionResultSet.getLevelKeyDataType(this.dimLevel11.getLevelName())[0], (int)2);
        DimensionTest2.assertEquals((int)dimesionResultSet.length(), (int)4);
        dimesionResultSet.seek(0);
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(0)[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(1)[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(2)[0], (Object)new Integer(1));
        dimesionResultSet.seek(1);
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(0)[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(1)[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(2)[0], (Object)new Integer(2));
        dimesionResultSet.seek(2);
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(0)[0], (Object)new Integer(2));
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(1)[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(2)[0], (Object)new Integer(5));
        dimesionResultSet.seek(3);
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(0)[0], (Object)new Integer(2));
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(1)[0], (Object)new Integer(1));
        DimensionTest2.assertEquals((Object)dimesionResultSet.getLevelKeyValue(2)[0], (Object)new Integer(6));
    }

    private Dimension createDimension(IDocumentManager documentManager) throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("l1", new String[]{"l1"}, null), new LevelDefinition("l2", new String[]{"l2"}, null), new LevelDefinition("l3", new String[]{"l3"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"student", (IDocumentManager)documentManager, (IDatasetIterator)new Dataset1(), (ILevelDefn[])levelDefs, (boolean)true, (StopSign)new StopSign());
        DimensionTest2.assertEquals((boolean)dimension.isTime(), (boolean)true);
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest2.assertEquals((String)hierarchy.getName(), (String)"student");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest2.assertEquals((String)level[0].getName(), (String)"l1");
        DimensionTest2.assertEquals((String)level[1].getName(), (String)"l2");
        DimensionTest2.assertEquals((String)level[2].getName(), (String)"l3");
        return (Dimension)dimension;
    }

    private Dimension createDimension2(IDocumentManager documentManager) throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("l1", new String[]{"l1"}, null), new LevelDefinition("l2", new String[]{"l2"}, null), new LevelDefinition("l3", new String[]{"l3"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"dataset2", (IDocumentManager)documentManager, (IDatasetIterator)new Dataset2(), (ILevelDefn[])levelDefs, (boolean)true, (StopSign)new StopSign());
        DimensionTest2.assertEquals((boolean)dimension.isTime(), (boolean)true);
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest2.assertEquals((String)hierarchy.getName(), (String)"dataset2");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest2.assertEquals((String)level[0].getName(), (String)"l1");
        DimensionTest2.assertEquals((String)level[1].getName(), (String)"l2");
        DimensionTest2.assertEquals((String)level[2].getName(), (String)"l3");
        return (Dimension)dimension;
    }

    private Dimension createDimension3(IDocumentManager documentManager) throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("l1", new String[]{"l1"}, null), new LevelDefinition("l2", new String[]{"l2"}, null), new LevelDefinition("l3", new String[]{"l3"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"dataset3", (IDocumentManager)documentManager, (IDatasetIterator)new Dataset3(), (ILevelDefn[])levelDefs, (boolean)true, (StopSign)new StopSign());
        DimensionTest2.assertEquals((boolean)dimension.isTime(), (boolean)true);
        IHierarchy hierarchy = dimension.getHierarchy();
        DimensionTest2.assertEquals((String)hierarchy.getName(), (String)"dataset3");
        ILevel[] level = hierarchy.getLevels();
        DimensionTest2.assertEquals((String)level[0].getName(), (String)"l1");
        DimensionTest2.assertEquals((String)level[1].getName(), (String)"l2");
        DimensionTest2.assertEquals((String)level[2].getName(), (String)"l3");
        return (Dimension)dimension;
    }
}

