/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.olap.data.util.PrimitiveDiskArray;

public class PrimaryDiskArrayTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInteger() throws IOException {
        int objectNumber = 1001;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)new Integer(i));
            ++i;
        }
        PrimaryDiskArrayTest.assertEquals((int)array.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            PrimaryDiskArrayTest.assertEquals((Object)array.get(i), (Object)new Integer(i));
            ++i;
        }
        array.close();
    }

    public void testDouble() throws IOException {
        int objectNumber = 1001;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)new Double(i));
            ++i;
        }
        PrimaryDiskArrayTest.assertEquals((int)array.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            PrimaryDiskArrayTest.assertEquals((Object)array.get(i), (Object)new Double(i));
            ++i;
        }
        array.close();
    }

    public void testBoolean() throws IOException {
        int objectNumber = 1001;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            if (i % 2 == 0) {
                array.add((Object)new Boolean(false));
            } else {
                array.add((Object)new Boolean(true));
            }
            ++i;
        }
        PrimaryDiskArrayTest.assertEquals((int)array.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            if (i % 2 == 0) {
                PrimaryDiskArrayTest.assertEquals((Object)array.get(i), (Object)new Boolean(false));
            } else {
                PrimaryDiskArrayTest.assertEquals((Object)array.get(i), (Object)new Boolean(true));
            }
            ++i;
        }
        array.close();
    }

    public void testString() throws IOException {
        int objectNumber = 200;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)("string" + i));
            ++i;
        }
        PrimaryDiskArrayTest.assertEquals((int)array.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            PrimaryDiskArrayTest.assertEquals((Object)array.get(i), (Object)("string" + i));
            ++i;
        }
        array.close();
    }

    public void testBigDecimal() throws IOException {
        int objectNumber = 3000;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        PrimaryDiskArrayTest.assertEquals((int)array.size(), (int)objectNumber);
        i = 0;
        while (i < objectNumber) {
            PrimaryDiskArrayTest.assertEquals((Object)array.get(i), (Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        array.close();
    }

    public void testDate() throws IOException {
        int objectNumber = 4101;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            PrimaryDiskArrayTest.assertEquals((Object)array.get(i), (Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        array.close();
    }
}

