/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.olap.data.util.PrimitiveDiskSortedStack;

public class PrimarySortedStackTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDistinctAsc() throws IOException {
        try {
            int objectNumber = 1001;
            PrimitiveDiskSortedStack stack = new PrimitiveDiskSortedStack(100, true, true);
            stack.push((Object)new Integer(200));
            stack.push((Object)new Integer(250));
            stack.push((Object)new Integer(208));
            stack.push((Object)new Integer(211));
            stack.push((Object)new Integer(211));
            stack.push((Object)new Integer(213));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)new Integer(i));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(i));
                ++i;
            }
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testDistinctDesc() throws IOException {
        try {
            int objectNumber = 1001;
            PrimitiveDiskSortedStack stack = new PrimitiveDiskSortedStack(100, false, true);
            stack.push((Object)new Integer(200));
            stack.push((Object)new Integer(250));
            stack.push((Object)new Integer(208));
            stack.push((Object)new Integer(211));
            stack.push((Object)new Integer(211));
            stack.push((Object)new Integer(213));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)new Integer(i));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(objectNumber - 1 - i));
                ++i;
            }
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testNotDistinctAsc() throws IOException {
        try {
            int objectNumber = 1001;
            PrimitiveDiskSortedStack stack = new PrimitiveDiskSortedStack(100, true, false);
            stack.push((Object)new Integer(2000));
            stack.push((Object)new Integer(2050));
            stack.push((Object)new Integer(2008));
            stack.push((Object)new Integer(2011));
            stack.push((Object)new Integer(2011));
            stack.push((Object)new Integer(2013));
            int i = 0;
            while (i < objectNumber) {
                if (i == 901) {
                    i = 901;
                }
                stack.push((Object)new Integer(i));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                if (i == 901) {
                    i = 901;
                }
                PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(i));
                ++i;
            }
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2000));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2008));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2011));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2011));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2013));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2050));
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testNotDistinctDesc() throws IOException {
        try {
            int objectNumber = 1001;
            PrimitiveDiskSortedStack stack = new PrimitiveDiskSortedStack(100, false, false);
            stack.push((Object)new Integer(2000));
            stack.push((Object)new Integer(2050));
            stack.push((Object)new Integer(2008));
            stack.push((Object)new Integer(2011));
            stack.push((Object)new Integer(2011));
            stack.push((Object)new Integer(2013));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)new Integer(i));
                ++i;
            }
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2050));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2013));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2011));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2011));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2008));
            PrimarySortedStackTest.assertEquals((Object)stack.pop(), (Object)new Integer(2000));
            i = 0;
            while (i < objectNumber) {
                Object memberForTest = stack.pop();
                PrimarySortedStackTest.assertEquals((Object)memberForTest, (Object)new Integer(objectNumber - 1 - i));
                ++i;
            }
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

