/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeElementFactory;
import org.eclipse.birt.data.engine.olap.impl.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.util.filter.DimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DimensionFilterProcessorTest
extends TestCase {
    private Scriptable baseScope;
    private ICubeQueryDefinition cubeQuery;
    private ScriptContext cx;

    public void setUp() {
        try {
            super.setUp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cx = new ScriptContext();
        this.baseScope = new ImporterTopLevel();
        this.cubeQuery = this.createCubeQueryDefinition();
    }

    public void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cx.exit();
    }

    private ICubeQueryDefinition createCubeQueryDefinition() {
        ICubeQueryDefinition cubeQuery = new CubeElementFactory().createCubeQuery("cube1");
        IEdgeDefinition columnEdge = cubeQuery.createEdge(2);
        cubeQuery.createEdge(1);
        IDimensionDefinition dimension1 = columnEdge.createDimension("dim1");
        IHierarchyDefinition hier1 = dimension1.createHierarchy("hier1");
        hier1.createLevel("level1");
        return cubeQuery;
    }

    public void testBasicFilter() throws DataException {
        ScriptExpression expr = new ScriptExpression("dimension[\"dim1\"][\"level1\"] * 2 + 2 == 6");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        DimensionFilterEvalHelper helper = new DimensionFilterEvalHelper(null, this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        ArrayList<String> levelNames = new ArrayList<String>();
        levelNames.add("level1");
        List resultRows = this.getResultRows1();
        boolean[] booleanResult = this.getBooleanResult1();
        int i = 0;
        while (i < booleanResult.length) {
            DimensionFilterProcessorTest.assertEquals((boolean)booleanResult[i], (boolean)helper.evaluateFilter((IResultRow)resultRows.get(i)));
            ++i;
        }
        helper.close();
        try {
            i = 0;
            while (i < booleanResult.length) {
                DimensionFilterProcessorTest.assertEquals((boolean)booleanResult[i], (boolean)helper.evaluateFilter((IResultRow)resultRows.get(i)));
                ++i;
            }
            DimensionFilterProcessorTest.fail((String)"should not arrive here");
        }
        catch (Exception exception) {}
    }

    public void testBasicFilter1() throws DataException {
        ScriptExpression expr = new ScriptExpression("dimension[\"dim1\"][\"level1\"][\"attr1\"] * 2 + 2 == 6");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        DimensionFilterEvalHelper helper = new DimensionFilterEvalHelper(null, this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        ArrayList<String> levelNames = new ArrayList<String>();
        levelNames.add("level1");
        List resultRows = this.getResultRows1();
        boolean[] booleanResult = this.getBooleanResult1();
        int i = 0;
        while (i < booleanResult.length) {
            DimensionFilterProcessorTest.assertEquals((boolean)booleanResult[i], (boolean)helper.evaluateFilter((IResultRow)resultRows.get(i)));
            ++i;
        }
    }

    public void testBasicFilter3() throws DataException {
        ScriptExpression expr = new ScriptExpression("dimension[\"dim1\"][\"level2\"][\"attr1\"] * 2 + 2 == 6");
        CubeFilterDefinition cubeFilter = new CubeFilterDefinition((IBaseExpression)expr);
        DimensionFilterEvalHelper helper = new DimensionFilterEvalHelper(null, this.baseScope, this.cx, this.cubeQuery, (IFilterDefinition)cubeFilter);
        ArrayList<String> levelNames = new ArrayList<String>();
        levelNames.add("level1");
        List resultRows = this.getResultRows1();
        boolean[] booleanResult = this.getBooleanResult1();
        try {
            int i = 0;
            while (i < booleanResult.length) {
                DimensionFilterProcessorTest.assertEquals((boolean)booleanResult[i], (boolean)helper.evaluateFilter((IResultRow)resultRows.get(i)));
                ++i;
            }
            DimensionFilterProcessorTest.fail((String)"Should not arrive here");
        }
        catch (Exception exception) {}
    }

    public List getResultRows1() {
        ArrayList<TempResultRow> result = new ArrayList<TempResultRow>();
        int i = 0;
        while (i < 5) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("level1", new Integer(i));
            map.put("attr1", new Integer(i));
            result.add(new TempResultRow(map));
            ++i;
        }
        return result;
    }

    private boolean[] getBooleanResult1() {
        boolean[] result = new boolean[5];
        int i = 0;
        while (i < 5) {
            result[i] = i == 2;
            ++i;
        }
        return result;
    }

    private class TempResultRow
    implements IResultRow {
        private Map nameValuePair;

        TempResultRow(Map nameValuePair) {
            this.nameValuePair = nameValuePair;
        }

        public Object getAggrValue(String aggrName) throws DataException {
            return null;
        }

        public Object getFieldValue(String name) throws DataException {
            return this.nameValuePair.get(name);
        }
    }
}

