/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.util.filter.InvalidCubePosFilter;
import org.eclipse.birt.data.engine.olap.util.filter.SimpleDiskList;
import org.eclipse.birt.data.engine.olap.util.filter.ValidCubePosFilter;

public class CubePosFilterTest
extends TestCase {
    public void setUp() {
    }

    public void testValidFilter1() throws DataException, IOException {
        ValidCubePosFilter validCubePosFilter = new ValidCubePosFilter(new String[]{"country", "year", "product"});
        IDiskArray[] simpleDiskLists = new SimpleDiskList[]{new SimpleDiskList(new int[]{1, 2, 3, 4, 6, 8, 9, 10, 11, 18}), new SimpleDiskList(new int[]{11, 12, 13, 14, 6, 8, 9, 10, 11, 18, 19}), new SimpleDiskList(new int[]{1, 3, 5, 7, 9, 18, 29, 40, 51, 58, 69})};
        validCubePosFilter.addDimPositions(simpleDiskLists);
        simpleDiskLists = new SimpleDiskList[]{new SimpleDiskList(new int[]{101, 102, 103}), new SimpleDiskList(new int[]{119}), new SimpleDiskList(new int[]{12, 69})};
        validCubePosFilter.addDimPositions(simpleDiskLists);
        CubePosFilterTest.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{101, 119, 12}));
        CubePosFilterTest.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{1, 11, 1}));
        CubePosFilterTest.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{1, 19, 69}));
        CubePosFilterTest.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{18, 19, 69}));
        CubePosFilterTest.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{11, 18, 69}));
        CubePosFilterTest.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{8, 8, 51}));
        CubePosFilterTest.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{1, 11, 69}));
        CubePosFilterTest.assertFalse((boolean)validCubePosFilter.getFilterResult(new int[]{1, 10, 11}));
        CubePosFilterTest.assertFalse((boolean)validCubePosFilter.getFilterResult(new int[3]));
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 69;
        CubePosFilterTest.assertFalse((boolean)validCubePosFilter.getFilterResult(nArray));
        CubePosFilterTest.assertFalse((boolean)validCubePosFilter.getFilterResult(new int[]{1, 119, 69}));
        CubePosFilterTest.assertFalse((boolean)validCubePosFilter.getFilterResult(new int[]{1, 11, 12}));
    }

    public void testInvalidFilter1() throws DataException, IOException {
        InvalidCubePosFilter invalidCubePosFilter = new InvalidCubePosFilter(new String[]{"country", "year", "product"});
        IDiskArray[] simpleDiskLists = new SimpleDiskList[]{new SimpleDiskList(new int[]{1, 2, 3, 4, 6, 8, 9, 10, 11, 18}), new SimpleDiskList(new int[]{11, 12, 13, 14, 6, 8, 9, 10, 11, 18, 19}), new SimpleDiskList(new int[]{1, 3, 5, 7, 9, 18, 29, 40, 51, 58, 69})};
        invalidCubePosFilter.addDimPositions(simpleDiskLists);
        simpleDiskLists = new SimpleDiskList[]{new SimpleDiskList(new int[]{101, 102, 103}), new SimpleDiskList(new int[]{119}), new SimpleDiskList(new int[]{12, 69})};
        invalidCubePosFilter.addDimPositions(simpleDiskLists);
        CubePosFilterTest.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{101, 119, 12}));
        CubePosFilterTest.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 11, 1}));
        CubePosFilterTest.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 19, 69}));
        CubePosFilterTest.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{18, 19, 69}));
        CubePosFilterTest.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{11, 18, 69}));
        CubePosFilterTest.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{8, 8, 51}));
        CubePosFilterTest.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 11, 69}));
        CubePosFilterTest.assertTrue((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 10, 11}));
        CubePosFilterTest.assertTrue((boolean)invalidCubePosFilter.getFilterResult(new int[3]));
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 69;
        CubePosFilterTest.assertTrue((boolean)invalidCubePosFilter.getFilterResult(nArray));
        CubePosFilterTest.assertTrue((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 119, 69}));
        CubePosFilterTest.assertTrue((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 11, 12}));
    }
}

