/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.perf.util;

import com.ibm.icu.util.Calendar;

public class TimeUtil {
    public static TimeUtil instance = new TimeUtil();

    public String getTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return this.getTimeStr(calendar);
    }

    private String getTimeStr(Calendar calendar) {
        int hour = calendar.get(10);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int milliSecond = calendar.get(14);
        return String.valueOf(hour) + "(h):" + minute + "(m):" + second + "(s):" + milliSecond + "(ms)";
    }

    public TimePoint getTimePoint() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return new TimePoint(calendar);
    }

    public long getTimePointSpan(TimePoint time1, TimePoint time2) {
        return time2.getCalendar().getTimeInMillis() - time1.getCalendar().getTimeInMillis();
    }

    public String getTimePointSpanStr(TimePoint time1, TimePoint time2) {
        return this.getTimePointSpanStr(time2.getCalendar().getTimeInMillis() - time1.getCalendar().getTimeInMillis());
    }

    public String getTimePointSpanStr(long milliSecondSpan) {
        int adjustValue = 1;
        if (milliSecondSpan < 0L) {
            milliSecondSpan *= -1L;
            adjustValue = -1;
        }
        int hour = (int)(milliSecondSpan / 3600000L);
        int minute = (int)((milliSecondSpan - (long)(hour * 1000 * 60 * 60)) / 60000L);
        int second = (int)((milliSecondSpan - (long)(hour * 1000 * 60 * 60) - (long)(minute * 1000 * 60)) / 1000L);
        int milliSecond = (int)(milliSecondSpan - (long)(hour * 1000 * 60 * 60) - (long)(minute * 1000 * 60) - (long)(second * 1000));
        String str = String.valueOf(hour) + "(h):" + minute + "(m):" + second + "(s):" + milliSecond + "(ms)";
        if (adjustValue < 0) {
            str = "- " + str;
        }
        return str;
    }

    public class TimePoint {
        private Calendar calendar;

        private TimePoint(Calendar calendar) {
            assert (calendar != null);
            this.calendar = calendar;
        }

        private Calendar getCalendar() {
            return this.calendar;
        }
    }
}

