/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.TestCase;
import org.eclipse.birt.report.data.oda.jdbc.CallStatement;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class CallStatementTest
extends TestCase {
    private Connection conn = null;
    private CallStatement stmt = null;

    protected void setUp() throws Exception {
        super.setUp();
        TestUtil.createTestData();
        TestUtil.createTestProcedure();
        this.conn = TestUtil.openConnection();
        this.stmt = (CallStatement)this.conn.newQuery("org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet");
        TestUtil.openJDBCConnection();
    }

    public void testGetMetaData() throws Exception {
        try {
            this.stmt.getMetaData();
            CallStatementTest.fail((String)"Should throw DriverException");
        }
        catch (OdaException e) {
            CallStatementTest.assertTrue((boolean)(e instanceof JDBCException));
        }
    }

    public void testSetBigDecimalintBigDecimal() throws Exception {
        this.stmt.prepare("call testProc0(?,?)");
        this.stmt.setBigDecimal(1, new BigDecimal("1111"));
        this.stmt.registerOutParameter(2, 3);
        this.stmt.executeQuery();
        assert (this.stmt.getBigDecimal(2).equals(new BigDecimal("2222")));
    }

    public void testSetDateintDate() throws Exception {
        this.stmt.prepare("call testProc1(?,?)");
        this.stmt.setDate(1, Date.valueOf("2000-01-01"));
        this.stmt.registerOutParameter(2, 91);
        this.stmt.executeQuery();
        assert (this.stmt.getDate(2).equals(Date.valueOf("2000-01-02")));
    }

    public void testSetDoubleintdouble() throws Exception {
        this.stmt.prepare("call testProc2(?,?)");
        this.stmt.setDouble(1, 0.0);
        this.stmt.registerOutParameter(2, 8);
        this.stmt.executeQuery();
        assert (this.stmt.getDouble(2) == 1.0);
    }

    public void testSetIntintint() throws Exception {
        this.stmt.prepare("call testProc3(?,?)");
        this.stmt.setInt(1, 0);
        this.stmt.registerOutParameter(2, -6);
        this.stmt.executeQuery();
        assert (this.stmt.getInt(2) == 1);
    }

    public void testSetStringintString() throws Exception {
        this.stmt.prepare("call testProc4(?,?)");
        this.stmt.setString(1, "00");
        this.stmt.registerOutParameter(2, 12);
        this.stmt.executeQuery();
        assert (this.stmt.getString(2).equals("11"));
    }

    public void testSetTimeintTime() throws Exception {
        this.stmt.prepare("call testProc5(?,?)");
        this.stmt.setTime(1, Time.valueOf("12:00:00"));
        this.stmt.registerOutParameter(2, 92);
        this.stmt.executeQuery();
        assert (this.stmt.getTime(2).equals(Time.valueOf("12:00:01")));
    }

    public void testSetTimestampintTimestamp() throws Exception {
        this.stmt.prepare("call testProc6(?,?)");
        this.stmt.setTimestamp(1, Timestamp.valueOf("2000-01-01 12:00:00.0000"));
        this.stmt.registerOutParameter(2, 93);
        this.stmt.executeQuery();
        assert (this.stmt.getTimestamp(2).equals(Timestamp.valueOf("2000-01-02 12:00:00.0000")));
    }

    public void testGetParameterMetaData() throws Exception {
        this.stmt.prepare("call testProc0(?,?)");
        IParameterMetaData md = this.stmt.getParameterMetaData();
        CallStatementTest.assertNotNull((Object)md);
    }

    public void testClearInParameters() throws Exception {
        this.stmt.prepare("call testProc3(?,?)");
        this.stmt.setInt(1, 0);
        this.stmt.registerOutParameter(2, 4);
        this.stmt.executeQuery();
        this.stmt.clearInParameters();
        try {
            this.stmt.executeQuery();
            CallStatementTest.fail();
        }
        catch (JDBCException jDBCException) {}
    }
}

