/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.DataSourceMetaData;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ConnectionTest
extends TestCase {
    public void setUp() throws Exception {
        super.setUp();
        TestUtil.createTestData();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        TestUtil.deleteTestData();
    }

    public ConnectionTest(String arg0) throws Exception {
        super(arg0);
    }

    public void testConnection() throws Exception {
        Connection conn = new Connection();
        ConnectionTest.assertFalse((boolean)conn.isOpen());
    }

    public void testClose() throws Exception {
        Connection conn = TestUtil.openConnection();
        conn.close();
        ConnectionTest.assertFalse((boolean)conn.isOpen());
        try {
            conn.close();
            Connection tempConn = new Connection();
            tempConn.close();
        }
        catch (OdaException odaException) {
            ConnectionTest.fail((String)"Close the closed operation should do nothing, no exception should be thrown.");
        }
    }

    public void testCommit() throws Exception {
        Connection conn = TestUtil.openConnection();
        Statement stmt = (Statement)conn.newQuery("");
        String sql = "update \"test_oda_jdbc\" set col0 = 7777 where col3=1";
        stmt.prepare(sql);
        stmt.execute();
        conn.commit();
        stmt.close();
        sql = "select col0 from \"test_oda_jdbc\" where col3 = 1";
        stmt.prepare(sql);
        ResultSet rs = (ResultSet)stmt.executeQuery();
        rs.next();
        ConnectionTest.assertEquals((double)rs.getDouble(1), (double)7777.0, (double)Double.MIN_VALUE);
        rs.close();
        stmt.close();
        sql = "update \"test_oda_jdbc\" set col0 = 1111 where col3=1";
        stmt.prepare(sql);
        stmt.execute();
        conn.commit();
        sql = "select col0 from \"test_oda_jdbc\" where col3 = 1";
        stmt.prepare(sql);
        rs = (ResultSet)stmt.executeQuery();
        rs.next();
        ConnectionTest.assertEquals((double)rs.getDouble(1), (double)1111.0, (double)Double.MIN_VALUE);
        conn.close();
    }

    public void testCreateStatement() throws Exception {
        Connection conn = TestUtil.openConnection();
        ConnectionTest.assertNotNull((Object)conn.newQuery(""));
        conn.close();
        try {
            ConnectionTest.assertNotNull((Object)conn.newQuery(""));
            ConnectionTest.fail();
        }
        catch (JDBCException jDBCException) {
        }
        catch (Exception exception) {
            ConnectionTest.fail();
        }
    }

    public void testGetMetaDataString() throws Exception {
        Connection conn = TestUtil.openConnection();
        ConnectionTest.assertNotNull((Object)conn.getMetaData(""));
        ConnectionTest.assertTrue((boolean)(conn.getMetaData("") instanceof DataSourceMetaData));
        conn.close();
    }

    public void testIsOpen() throws Exception {
        Connection conn = TestUtil.openConnection();
        ConnectionTest.assertTrue((boolean)conn.isOpen());
        conn.close();
        ConnectionTest.assertFalse((boolean)conn.isOpen());
    }

    public void testOpen() throws Exception {
        Connection conn = new Connection();
        Properties props = new Properties();
        props.setProperty("odaURL", TestUtil.getURL());
        props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
        props.setProperty("odaUser", TestUtil.getUser());
        props.setProperty("odaPassword", TestUtil.getPassword());
        conn.open(props);
        ConnectionTest.assertTrue((boolean)conn.isOpen());
        conn.close();
        try {
            conn = new Connection();
            props = new Properties();
            props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
            props.setProperty("odaUser", TestUtil.getUser());
            props.setProperty("odaPassword", TestUtil.getPassword());
            conn.open(props);
            ConnectionTest.fail((String)"Open Connection with null URL info should throw exception");
        }
        catch (OdaException odaException) {}
        try {
            conn = new Connection();
            props = new Properties();
            props.setProperty("odaURL", TestUtil.getURL());
            props.setProperty("odaUser", TestUtil.getUser());
            props.setProperty("odaPassword", TestUtil.getPassword());
            conn.open(props);
            conn.close();
        }
        catch (OdaException odaException) {
            ConnectionTest.fail((String)"Open Connection should succeed");
        }
        try {
            conn = new Connection();
            props = new Properties();
            props.setProperty("odaURL", String.valueOf(TestUtil.getURL()) + ";user=" + TestUtil.getUser() + ";password=" + TestUtil.getPassword());
            props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
            props.setProperty("odaPassword", TestUtil.getPassword());
            conn.open(props);
            conn.close();
        }
        catch (OdaException odaException) {
            ConnectionTest.fail((String)"Open Connection should succeed");
        }
        try {
            conn = new Connection();
            props = new Properties();
            props.setProperty("odaURL", "wrong url");
            props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
            props.setProperty("odaUser", TestUtil.getUser());
            conn.open(props);
            ConnectionTest.fail((String)"Open Connection with wrong property should throw exception");
        }
        catch (OdaException odaException) {}
    }

    public void testRollback() throws Exception {
        Connection conn = TestUtil.openConnection();
        try {
            conn.rollback();
        }
        catch (Exception exception) {
            ConnectionTest.fail((String)"Exception occurred when calling rollback()");
        }
        conn.close();
    }
}

