/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.DatabaseMetaData;
import junit.framework.TestCase;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.DataSourceMetaData;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.IConnection;

public class DataSourceMetaDataTest
extends TestCase {
    OdaJdbcDriver connFact;
    Connection conn1;
    DataSourceMetaData dbMeta1;
    Connection conn2;
    DataSourceMetaData dbMeta2;

    public void setUp() throws Exception {
        super.setUp();
        this.conn1 = TestUtil.openConnection();
        this.conn2 = TestUtil.openConnection();
        this.conn2.close();
        this.dbMeta1 = (DataSourceMetaData)this.conn1.getMetaData("");
        this.dbMeta2 = (DataSourceMetaData)this.conn2.getMetaData("");
    }

    protected void tearDown() throws Exception {
        this.conn1.close();
        super.tearDown();
    }

    public DataSourceMetaDataTest(String arg0) throws Exception {
        super(arg0);
    }

    public void testDataSourceMetaData() throws Exception {
        DataSourceMetaData tempMeta = new DataSourceMetaData((IConnection)new Connection(), TestUtil.openJDBCConnection().getMetaData());
        DataSourceMetaDataTest.assertNotNull((Object)tempMeta);
    }

    public void testGetConnection() throws Exception {
        DataSourceMetaDataTest.assertEquals((Object)this.dbMeta1.getConnection(), (Object)this.conn1);
        DataSourceMetaDataTest.assertEquals((Object)this.dbMeta2.getConnection(), (Object)this.conn2);
    }

    public void testGetDataSourceObjects() throws Exception {
        DataSourceMetaDataTest.assertNull((Object)this.dbMeta1.getDataSourceObjects("", "", "", ""));
        DataSourceMetaDataTest.assertNull((Object)this.dbMeta2.getDataSourceObjects("", "", "", ""));
    }

    public void testGetDataSourceMajorVersion() throws Exception {
    }

    public void testGetDataSourceMinorVersion() throws Exception {
    }

    public void testGetDataSourceProductName() throws Exception {
    }

    public void testGetDataSourceProductVersion() throws Exception {
    }

    public void testGetSQLStateType() throws Exception {
        try {
            this.dbMeta2.getSQLStateType();
            DataSourceMetaDataTest.fail((String)"call getSQLStateType from DataSourceMetaData which is from the non-opened connection should throw exception.");
        }
        catch (JDBCException jDBCException) {}
        java.sql.Connection jdbcConn = TestUtil.openJDBCConnection();
        DatabaseMetaData dbMeta = jdbcConn.getMetaData();
        if (dbMeta.getSQLStateType() == 2) {
            DataSourceMetaDataTest.assertEquals((int)this.dbMeta1.getSQLStateType(), (int)1);
        } else {
            DataSourceMetaDataTest.assertEquals((int)this.dbMeta1.getSQLStateType(), (int)0);
        }
    }

    public void testSupportsMultipleOpenResults() throws Exception {
        DataSourceMetaDataTest.assertFalse((boolean)this.dbMeta1.supportsMultipleOpenResults());
        DataSourceMetaDataTest.assertFalse((boolean)this.dbMeta2.supportsMultipleOpenResults());
    }

    public void testSupportsMultipleResultSets() throws Exception {
        DataSourceMetaDataTest.assertTrue((boolean)this.dbMeta1.supportsMultipleResultSets());
        DataSourceMetaDataTest.assertTrue((boolean)this.dbMeta2.supportsMultipleResultSets());
    }

    public void testSupportsNamedResultSets() throws Exception {
        DataSourceMetaDataTest.assertTrue((boolean)this.dbMeta1.supportsNamedResultSets());
        DataSourceMetaDataTest.assertTrue((boolean)this.dbMeta2.supportsNamedResultSets());
    }

    public void testSupportsNamedParameters() throws Exception {
        DataSourceMetaDataTest.assertFalse((boolean)this.dbMeta1.supportsNamedParameters());
        DataSourceMetaDataTest.assertFalse((boolean)this.dbMeta2.supportsNamedParameters());
    }

    public void testSupportsInParameters() throws Exception {
        DataSourceMetaDataTest.assertTrue((boolean)this.dbMeta1.supportsInParameters());
        DataSourceMetaDataTest.assertTrue((boolean)this.dbMeta2.supportsInParameters());
    }

    public void testSupportsOutParameters() throws Exception {
        DataSourceMetaDataTest.assertTrue((boolean)this.dbMeta1.supportsOutParameters());
        DataSourceMetaDataTest.assertTrue((boolean)this.dbMeta2.supportsOutParameters());
    }

    public void testGetSortMode() throws Exception {
        DataSourceMetaDataTest.assertEquals((int)this.dbMeta1.getSortMode(), (int)0);
        DataSourceMetaDataTest.assertEquals((int)this.dbMeta2.getSortMode(), (int)0);
    }
}

