/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.PreparedStatement;
import junit.framework.TestCase;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.ResultSetMetaData;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;

public class ResultSetMetaDataTest
extends TestCase {
    private Connection conn1 = null;
    private Connection conn2 = null;
    private Statement stmt1 = null;
    private Statement stmt2 = null;
    private ResultSet rs = null;
    private ResultSetMetaData rsmd_ResultSet = null;
    private ResultSetMetaData rsmd_Statement = null;
    private java.sql.Connection jdbcConn1 = null;
    private java.sql.Connection jdbcConn2 = null;
    private java.sql.Statement jdbcStmt = null;
    private PreparedStatement jdbcPreparedStmt = null;
    private java.sql.ResultSet jdbcRs = null;
    private java.sql.ResultSetMetaData jdbcRsmd_ResultSet = null;
    private java.sql.ResultSetMetaData jdbcRsmd_PreparedStmt = null;

    protected void setUp() throws Exception {
        TestUtil.createTestData();
        this.conn1 = TestUtil.openConnection();
        this.conn2 = TestUtil.openConnection();
        this.stmt1 = (Statement)this.conn1.newQuery("");
        this.stmt2 = (Statement)this.conn2.newQuery("");
        String sql = "select * from \"test_oda_jdbc\"";
        this.stmt1.prepare(sql);
        this.rs = (ResultSet)this.stmt1.executeQuery();
        this.rsmd_ResultSet = (ResultSetMetaData)this.rs.getMetaData();
        this.stmt2.prepare(sql);
        this.rsmd_Statement = (ResultSetMetaData)this.stmt2.getMetaData();
        this.jdbcConn1 = TestUtil.openJDBCConnection();
        this.jdbcConn2 = TestUtil.openJDBCConnection();
        this.jdbcStmt = this.jdbcConn1.createStatement();
        this.jdbcRs = this.jdbcStmt.executeQuery(sql);
        this.jdbcRsmd_ResultSet = this.jdbcRs.getMetaData();
        this.jdbcPreparedStmt = this.jdbcConn2.prepareStatement(sql);
        this.jdbcRsmd_PreparedStmt = this.jdbcPreparedStmt.getMetaData();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.rs.close();
        this.stmt1.close();
        this.stmt2.close();
        this.conn1.close();
        this.conn2.close();
        this.jdbcRs.close();
        this.jdbcStmt.close();
        this.jdbcConn1.close();
        this.jdbcConn2.close();
        TestUtil.deleteTestData();
        super.tearDown();
    }

    public void testGetColumnCount_ResultSet() throws Exception {
        ResultSetMetaDataTest.assertEquals((int)this.rsmd_ResultSet.getColumnCount(), (int)this.jdbcRsmd_ResultSet.getColumnCount());
    }

    public void testGetColumnName_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            System.out.println("i = " + i);
            System.out.println("rsmd_ResultSet getColumnName  = " + this.rsmd_ResultSet.getColumnName(i));
            ResultSetMetaDataTest.assertEquals((String)this.rsmd_ResultSet.getColumnName(i), (String)this.jdbcRsmd_ResultSet.getColumnName(i));
            ++i;
        }
    }

    public void testGetColumnLabel_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((String)this.rsmd_ResultSet.getColumnLabel(i), (String)this.jdbcRsmd_ResultSet.getColumnLabel(i));
            ++i;
        }
    }

    public void testGetColumnType_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_ResultSet.getColumnType(i), (int)this.jdbcRsmd_ResultSet.getColumnType(i));
            ++i;
        }
    }

    public void testGetColumnTypeName_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((String)this.rsmd_ResultSet.getColumnTypeName(i), (String)this.jdbcRsmd_ResultSet.getColumnTypeName(i));
            ++i;
        }
    }

    public void testGetColumnDisplayLength_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_ResultSet.getColumnDisplayLength(i), (int)this.jdbcRsmd_ResultSet.getColumnDisplaySize(i));
            ++i;
        }
    }

    public void testGetPrecision_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_ResultSet.getPrecision(i), (int)this.jdbcRsmd_ResultSet.getPrecision(i));
            ++i;
        }
    }

    public void testGetScale_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_ResultSet.getScale(i), (int)this.jdbcRsmd_ResultSet.getScale(i));
            ++i;
        }
    }

    public void testIsNullable_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_ResultSet.isNullable(i), (int)this.jdbcRsmd_ResultSet.isNullable(i));
            ++i;
        }
    }

    public void testGetColumnCount_Statment() throws Exception {
        ResultSetMetaDataTest.assertEquals((int)this.rsmd_Statement.getColumnCount(), (int)this.jdbcRsmd_PreparedStmt.getColumnCount());
    }

    public void testGetColumnName_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((String)this.rsmd_Statement.getColumnName(i), (String)this.jdbcRsmd_PreparedStmt.getColumnName(i));
            ++i;
        }
    }

    public void testGetColumnLabel_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((String)this.rsmd_Statement.getColumnLabel(i), (String)this.jdbcRsmd_PreparedStmt.getColumnLabel(i));
            ++i;
        }
    }

    public void testGetColumnType_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_Statement.getColumnType(i), (int)this.jdbcRsmd_PreparedStmt.getColumnType(i));
            ++i;
        }
    }

    public void testGetColumnTypeName_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((String)this.rsmd_Statement.getColumnTypeName(i), (String)this.jdbcRsmd_PreparedStmt.getColumnTypeName(i));
            ++i;
        }
    }

    public void testGetColumnDisplayLength_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_Statement.getColumnDisplayLength(i), (int)this.jdbcRsmd_PreparedStmt.getColumnDisplaySize(i));
            ++i;
        }
    }

    public void testGetPrecision_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_Statement.getPrecision(i), (int)this.jdbcRsmd_PreparedStmt.getPrecision(i));
            ++i;
        }
    }

    public void testGetScale_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_Statement.getScale(i), (int)this.jdbcRsmd_PreparedStmt.getScale(i));
            ++i;
        }
    }

    public void testIsNullable_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            ResultSetMetaDataTest.assertEquals((int)this.rsmd_Statement.isNullable(i), (int)this.jdbcRsmd_PreparedStmt.isNullable(i));
            ++i;
        }
    }
}

