/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;

class Tree {
    Node root;

    Tree() {
    }

    Long[] getEdges(Node node) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        while (node != null) {
            nodes.addFirst(node);
            node = node.parent;
        }
        Iterator iter = nodes.iterator();
        Long[] edges = new Long[nodes.size()];
        int i = 0;
        while (iter.hasNext()) {
            node = (Node)iter.next();
            edges[i++] = new Long(node.offset);
        }
        return edges;
    }

    public String getTree() {
        StringBuffer buffer = new StringBuffer();
        this.visitTree(buffer, this.root, null);
        return buffer.toString();
    }

    void visitTree(StringBuffer buffer, Node node, Fragment fragment) {
        if (fragment == null || fragment.inFragment((Object)new Long(node.offset))) {
            buffer.append(node.toString());
            buffer.append(',');
        }
        Node child = node.child;
        while (child != null) {
            this.visitTree(buffer, child, fragment);
            child = child.next;
        }
    }

    Node findNode(long offset) {
        return this.findNode(this.root, offset);
    }

    private Node findNode(Node node, long offset) {
        if (node.offset == offset) {
            return node;
        }
        Node child = node.child;
        while (child != null) {
            Node target = this.findNode(child, offset);
            if (target != null) {
                return target;
            }
            child = child.next;
        }
        return null;
    }

    static class Node {
        long offset;
        Node parent;
        Node child;
        Node next;

        Node(long offset) {
            this.offset = offset;
        }

        void addChild(Node node) {
            if (this.child == null) {
                this.child = node;
                node.parent = this;
                return;
            }
            Node lastChild = this.child;
            while (lastChild.next != null) {
                lastChild = lastChild.next;
            }
            lastChild.next = node;
            node.parent = this;
        }

        public String toString() {
            if (this.parent == null) {
                return String.valueOf(this.offset);
            }
            StringBuffer buffer = new StringBuffer();
            this.toString(buffer);
            return buffer.toString();
        }

        public void toString(StringBuffer buffer) {
            if (this.parent == null) {
                buffer.append(String.valueOf(this.offset));
            } else {
                this.parent.toString(buffer);
                buffer.append(".");
                buffer.append(String.valueOf(this.offset));
            }
        }
    }
}

