/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import junit.framework.TestCase;
import org.eclipse.birt.report.engine.internal.executor.doc.Tree;
import org.eclipse.birt.report.engine.internal.executor.doc.TreeFragment;

public class TreeFragmentTest
extends TestCase {
    Tree tree;
    TreeFragment fragment;

    public void setUp() {
        this.createTree();
    }

    public void testFragment() {
        TreeFragment treeFrag = new TreeFragment(this.tree);
        treeFrag.addFragment(1L, 6L);
        String sFrag = treeFrag.toString();
        TreeFragmentTest.assertEquals((String)"0,1,2,3,4,5,6,", (String)sFrag);
        treeFrag.addFragment(8L, 9L);
        sFrag = treeFrag.toString();
        TreeFragmentTest.assertEquals((String)"0,1,2,3,4,5,6,8,9,", (String)sFrag);
        treeFrag.addFragment(11L, 11L);
        sFrag = treeFrag.toString();
        TreeFragmentTest.assertEquals((String)"0,1,2,3,4,5,6,8,9,11,", (String)sFrag);
    }

    void createTree() {
        this.tree = new Tree();
        this.tree.root = new Tree.Node(0L);
        this.createTreeNodes(this.tree.root, 3, 1);
    }

    long createTreeNodes(Tree.Node root, int childCount, int level) {
        long offset = root.offset + 1L;
        int i = 0;
        while (i < childCount) {
            Tree.Node child = new Tree.Node(offset++);
            root.addChild(child);
            if (level > 0) {
                offset = this.createTreeNodes(child, childCount, level - 1);
            }
            ++i;
        }
        return offset;
    }
}

