/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import junit.framework.TestCase;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.internal.index.v2.IndexReader;
import org.eclipse.birt.report.engine.internal.index.v2.IndexWriter;

public class IndexReadWriteTest
extends TestCase {
    static final String ARCHIVE_NAME = "./utest/index.dat";
    static final String ENTRY_NAME = "/test";

    public void testInline() throws Exception {
        int entryCount = 10000;
        ArchiveFile af = new ArchiveFile(ARCHIVE_NAME, "rw");
        try {
            IndexWriter writer = new IndexWriter((IDocArchiveWriter)new ArchiveWriter((IArchiveFile)af), ENTRY_NAME);
            try {
                int i = 0;
                while (i < entryCount) {
                    writer.add(String.valueOf(i), Long.valueOf(i).longValue());
                    ++i;
                }
            }
            finally {
                writer.close();
            }
            System.out.println(String.valueOf(entryCount) + " size:" + af.getEntry(ENTRY_NAME).getLength());
            IndexReader reader = new IndexReader((IDocArchiveReader)new ArchiveReader((IArchiveFile)af), ENTRY_NAME);
            try {
                int i = 0;
                while (i < entryCount) {
                    Long value = reader.get(String.valueOf(i));
                    IndexReadWriteTest.assertEquals((int)i, (int)value.intValue());
                    ++i;
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            af.close();
        }
    }

    public void testExternal() throws Exception {
        int entryCount = 10001;
        ArchiveFile af = new ArchiveFile(ARCHIVE_NAME, "rw");
        try {
            IndexWriter writer = new IndexWriter((IDocArchiveWriter)new ArchiveWriter((IArchiveFile)af), ENTRY_NAME);
            try {
                int i = 0;
                while (i < entryCount) {
                    writer.add(String.valueOf(i), Long.valueOf(i).longValue());
                    ++i;
                }
            }
            finally {
                writer.close();
            }
            System.out.println(String.valueOf(entryCount) + " size:" + af.getEntry(ENTRY_NAME).getLength());
            IndexReader reader = new IndexReader((IDocArchiveReader)new ArchiveReader((IArchiveFile)af), ENTRY_NAME);
            try {
                int i = 0;
                while (i < entryCount) {
                    Long value = reader.get(String.valueOf(i));
                    IndexReadWriteTest.assertEquals((int)i, (int)value.intValue());
                    ++i;
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            af.close();
        }
    }
}

