/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.ReportEngine;

public class DataSourceCompareTest
extends EngineCase {
    static final String DATASOURCE_RESOURCE = "org/eclipse/birt/report/engine/api/dataSource.rptdesign";
    static final String MODIFIED_RESOURCE = "org/eclipse/birt/report/engine/api/dataSource_target.rptdesign";
    static final String NEST_QUERY_DATASOURCE_RESOURCE = "org/eclipse/birt/report/engine/api/dataSource_nestQuery.rptdesign";
    static final String MODIFIED_NEST_QUERY_RESOURCE = "org/eclipse/birt/report/engine/api/dataSource_nestQuery_target.rptdesign";
    static final String SUB_QUERY_DATASOURCE_RESOURCE = "org/eclipse/birt/report/engine/api/dataSource_subQuery.rptdesign";
    static final String MODIFIED_SUB_QUERY_RESOURCE = "org/eclipse/birt/report/engine/api/dataSource_subQuery_target.rptdesign";
    static final String UTEST_FOLDER = "./utest/.birt.report.engine.api.DataSourceTest/";
    static final String DATASOURCE_DESIGN = "./utest/.birt.report.engine.api.DataSourceTest/source.rptdesign";
    static final String DATASOURCE_DOCUMENT = "./utest/.birt.report.engine.api.DataSourceTest/source.rptdocument";
    static final String MODIFIED_DESIGN = "./utest/.birt.report.engine.api.DataSourceTest/modified.rptdesign";
    static final String MODIFIED_DOCUMENT = "./utest/.birt.report.engine.api.DataSourceTest/modified.rptdocument";
    static final String GOLDEN_HTML = "./utest/.birt.report.engine.api.DataSourceTest/golden.html";
    static final String RESULT_HTML = "./utest/.birt.report.engine.api.DataSourceTest/modified.html";

    public void setUp() {
        this.removeFile(UTEST_FOLDER);
        new File(UTEST_FOLDER).mkdirs();
    }

    public void tearDown() {
        this.removeFile(UTEST_FOLDER);
    }

    private void doTestRender(String sourceResource, String changedResource) throws Exception {
        this.copyResource(sourceResource, DATASOURCE_DESIGN);
        new EngineTask(DATASOURCE_DESIGN, DATASOURCE_DOCUMENT, null, null).doRunTask();
        this.copyResource(changedResource, MODIFIED_DESIGN);
        new EngineTask(MODIFIED_DESIGN, MODIFIED_DOCUMENT, DATASOURCE_DOCUMENT, null).doRunTask();
        new EngineTask(null, MODIFIED_DOCUMENT, DATASOURCE_DOCUMENT, RESULT_HTML).doRenderTask();
        new EngineTask(MODIFIED_DESIGN, MODIFIED_DOCUMENT, null, null).doRunTask();
        new EngineTask(null, MODIFIED_DOCUMENT, null, GOLDEN_HTML).doRenderTask();
        this.compare(GOLDEN_HTML, RESULT_HTML);
    }

    private void doTestRunAndRender(String sourceResource, String changedResource) throws Exception {
        this.copyResource(sourceResource, DATASOURCE_DESIGN);
        new EngineTask(DATASOURCE_DESIGN, DATASOURCE_DOCUMENT, null, null).doRunTask();
        this.copyResource(changedResource, MODIFIED_DESIGN);
        new EngineTask(MODIFIED_DESIGN, null, DATASOURCE_DOCUMENT, RESULT_HTML).doRunAndRenderTask();
        new EngineTask(MODIFIED_DESIGN, null, null, GOLDEN_HTML).doRunAndRenderTask();
        this.compare(GOLDEN_HTML, RESULT_HTML);
    }

    public void testTable() throws Exception {
        this.doTestRender(DATASOURCE_RESOURCE, MODIFIED_RESOURCE);
        this.doTestRunAndRender(DATASOURCE_RESOURCE, MODIFIED_RESOURCE);
    }

    public void testSubQuery() throws Exception {
        this.doTestRender(SUB_QUERY_DATASOURCE_RESOURCE, MODIFIED_SUB_QUERY_RESOURCE);
        this.doTestRunAndRender(SUB_QUERY_DATASOURCE_RESOURCE, MODIFIED_SUB_QUERY_RESOURCE);
    }

    private void compare(String goldenFile, String resultFile) throws Exception {
        this.loadContent(goldenFile);
        this.loadContent(resultFile);
    }

    public String loadContent(String src) throws Exception {
        FileInputStream in = new FileInputStream(src);
        DataSourceCompareTest.assertTrue((in != null ? 1 : 0) != 0);
        try {
            int size = ((InputStream)in).available();
            byte[] buffer = new byte[size];
            ((InputStream)in).read(buffer);
            ((InputStream)in).close();
            return new String(buffer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DataSourceCompareTest.fail();
            return null;
        }
    }

    class EngineTask {
        private String designFile;
        private String documentFile;
        private String dataSourceFile;
        private String targetFile;

        public EngineTask(String designFile, String documentFile, String dataSourceFile, String targetFile) {
            this.designFile = designFile;
            this.documentFile = documentFile;
            this.dataSourceFile = dataSourceFile;
            this.targetFile = targetFile;
        }

        protected IDocArchiveReader openDataSource(String dataSourceFile) throws Exception {
            if (dataSourceFile == null || dataSourceFile.length() == 0) {
                return null;
            }
            if (dataSourceFile.endsWith("\\") || dataSourceFile.endsWith("/")) {
                return new FolderArchiveReader(dataSourceFile);
            }
            return new FileArchiveReader(dataSourceFile);
        }

        public void doRunTask() throws Exception {
            EngineConfig config = new EngineConfig();
            ReportEngine engine = new ReportEngine(config);
            IReportRunnable report = engine.openReportDesign(this.designFile);
            IRunTask task = engine.createRunTask(report);
            IDocArchiveReader dataSource = this.openDataSource(this.dataSourceFile);
            if (dataSource != null) {
                task.setDataSource(dataSource);
            }
            task.run(this.documentFile);
            task.close();
            if (dataSource != null) {
                dataSource.close();
            }
            engine.shutdown();
        }

        public void doRenderTask() throws Exception {
            EngineConfig config = new EngineConfig();
            ReportEngine engine = new ReportEngine(config);
            IReportDocument reportDoc = engine.openReportDocument(this.documentFile);
            IRenderTask task = engine.createRenderTask(reportDoc);
            HTMLRenderOption option = new HTMLRenderOption();
            option.setOutputFormat("html");
            option.setOutputFileName(this.targetFile);
            task.setRenderOption((IRenderOption)option);
            IDocArchiveReader dataSource = this.openDataSource(this.dataSourceFile);
            if (dataSource != null) {
                task.setDataSource(dataSource);
            }
            task.render();
            reportDoc.close();
            if (dataSource != null) {
                dataSource.close();
            }
            task.close();
            engine.shutdown();
        }

        public void doRunAndRenderTask() throws Exception {
            EngineConfig config = new EngineConfig();
            ReportEngine engine = new ReportEngine(config);
            IReportRunnable report = engine.openReportDesign(this.designFile);
            IRunAndRenderTask task = engine.createRunAndRenderTask(report);
            HTMLRenderOption option = new HTMLRenderOption();
            option.setOutputFormat("html");
            option.setOutputFileName(this.targetFile);
            task.setRenderOption((IRenderOption)option);
            IDocArchiveReader dataSource = this.openDataSource(this.dataSourceFile);
            if (dataSource != null) {
                task.setDataSource(dataSource);
            }
            task.run();
            task.close();
            engine.shutdown();
        }
    }
}

