/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentInfo;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class EngineTaskCancelTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/six_pages_design.xml";
    static final String REPORT_DESIGN = "design.rptdesign";
    static final String REPORT_DOCUMENT = "./reportdocument.folder/";

    protected void setUp() throws Exception {
        super.setUp();
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
    }

    protected void tearDown() throws Exception {
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
        super.tearDown();
    }

    public void testCancelInPageHandler() throws Exception {
        IReportRunnable runnable = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask runTask = this.engine.createRunTask(runnable);
        runTask.setPageHandler((IPageHandler)new CancelPageHandler((IEngineTask)runTask));
        runTask.run(REPORT_DOCUMENT);
        runTask.close();
        EngineTaskCancelTest.assertEquals((int)4, (int)runTask.getStatus());
        IReportDocument reportDoc = this.engine.openReportDocument(REPORT_DOCUMENT);
        EngineTaskCancelTest.assertTrue((reportDoc.getPageCount() < 6L ? 1 : 0) != 0);
        reportDoc.close();
    }

    private class CancelPageHandler
    implements IPageHandler {
        IEngineTask task;

        CancelPageHandler(IEngineTask task) {
            this.task = task;
        }

        public void onPage(int pageNumber, boolean checkpoint, IReportDocumentInfo doc) {
            if (pageNumber == 2) {
                this.task.cancel();
            }
        }
    }
}

