/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class EngintTaskLoggerTest
extends EngineCase {
    public void testLogger() throws Exception {
        Logger engineLogger = Logger.getAnonymousLogger();
        ByteArrayOutputStream engineOut = new ByteArrayOutputStream();
        StreamHandler engineHandler = new StreamHandler(engineOut, new SimpleFormatter());
        engineHandler.setLevel(Level.ALL);
        engineLogger.addHandler(engineHandler);
        engineLogger.setLevel(Level.ALL);
        Logger taskLogger = Logger.getAnonymousLogger();
        ByteArrayOutputStream taskOut = new ByteArrayOutputStream();
        StreamHandler taskHandler = new StreamHandler(taskOut, new SimpleFormatter());
        taskHandler.setLevel(Level.ALL);
        taskLogger.addHandler(taskHandler);
        taskLogger.setLevel(Level.ALL);
        this.engine.setLogger(engineLogger);
        this.engine.changeLogLevel(Level.ALL);
        engineHandler.flush();
        taskHandler.flush();
        new File("./utest/").mkdirs();
        this.copyResource("org/eclipse/birt/report/engine/api/engine-task-logger-test.rptdesign", "./utest/reportdesign.rptdesign");
        IReportRunnable runnable = this.engine.openReportDesign("./utest/reportdesign.rptdesign");
        IRunTask task = this.engine.createRunTask(runnable);
        task.setParameter("sample", (Object)"==golden values==", "displayText");
        task.run("./utest/report.rptdocument");
        task.close();
        engineHandler.flush();
        EngintTaskLoggerTest.assertTrue((engineOut.toString().indexOf("==golden values==") != -1 ? 1 : 0) != 0);
        engineOut.reset();
        task = this.engine.createRunTask(runnable);
        task.setLogger(taskLogger);
        task.setParameter("sample", (Object)"==golden values==", "displayText");
        task.run("./utest/report.rptdocument");
        task.close();
        engineHandler.flush();
        taskHandler.flush();
        EngintTaskLoggerTest.assertTrue((engineOut.toString().indexOf("==golden values==") == -1 ? 1 : 0) != 0);
        EngintTaskLoggerTest.assertTrue((taskOut.toString().indexOf("==golden values==") != -1 ? 1 : 0) != 0);
    }
}

