/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.HTMLCompleteImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.engine.api.impl.Image;

public class HTMLCompleteImageHandlerTest
extends EngineCase {
    protected IReportEngine engine = null;
    protected IReportRunnable runnable = null;
    protected static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/HTMLCompleteImageHandlerTest.rptdesign";
    protected static final String REPORT_DESIGN = "HTMLCompleteImageHandlerTest.rptdesign";

    public void setUp() throws Exception {
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.engine = this.createReportEngine();
        this.runnable = this.engine.openReportDesign(REPORT_DESIGN);
    }

    public void tearDown() {
        if (this.engine != null) {
            this.engine.shutdown();
        }
        this.removeFile(REPORT_DESIGN);
    }

    public void testOnDocImage() {
        HTMLCompleteImageHandler handler = new HTMLCompleteImageHandler();
        String result = handler.onDocImage(null, null);
        HTMLCompleteImageHandlerTest.assertNull((Object)result);
    }

    public void testOnURLImage() {
        try {
            HTMLRenderContext context = new HTMLRenderContext();
            context.setImageDirectory("");
            Image image = new Image("https://mail.google.com/mail/help/images/logo1.gif");
            HTMLCompleteImageHandler handler = new HTMLCompleteImageHandler();
            String urlString = handler.onURLImage((IImage)image, (Object)context);
            URL url = this.runnable.getDesignHandle().getModule().findResource(urlString, 1);
            InputStream inputStream = url.openConnection().getInputStream();
            int availableBytes = inputStream.available();
            assert (availableBytes > 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HTMLCompleteImageHandlerTest.fail();
        }
    }

    public void testOnFileImage() {
    }

    public void testoOnCustomImage() {
    }

    public void testOnDesignImage() {
        HTMLRenderContext context = new HTMLRenderContext();
        context.setImageDirectory("");
        Image image = (Image)this.runnable.getImage("img.jpg");
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        HTMLCompleteImageHandler imageHandler = new HTMLCompleteImageHandler();
        String resultPath = imageHandler.onDesignImage((IImage)image, (Object)context);
        HTMLCompleteImageHandlerTest.assertTrue((boolean)this.isFilePathLegal(resultPath));
    }

    private boolean isFilePathLegal(String filePath) {
        try {
            URL fileURL = new URL(filePath);
            return fileURL.openStream() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

