/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.engine.api.impl.Image;

public class HTMLServerImageHandlerTest
extends EngineCase {
    protected IReportEngine engine = null;
    protected IReportRunnable runnable = null;
    protected static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/HTMLServerImageHandlerTest.rptdesign";
    protected static final String REPORT_DESIGN = "HTMLServerImageHandlerTest.rptdesign";

    public void setUp() throws Exception {
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.engine = this.createReportEngine();
        this.runnable = this.engine.openReportDesign(REPORT_DESIGN);
    }

    public void tearDown() {
        if (this.engine != null) {
            this.engine.shutdown();
        }
        this.removeFile(REPORT_DESIGN);
    }

    public void testMultiTypesImage() {
        String blankURL = "http://image";
        Image image = new Image(blankURL);
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = -1;
        int[] imageTypes = nArray;
        HTMLRenderContext context = new HTMLRenderContext();
        HTMLServerImageHandler handler = new HTMLServerImageHandler();
        int size = imageTypes.length;
        int index = 0;
        while (index < size) {
            String result = null;
            switch (imageTypes[index]) {
                case 0: {
                    result = handler.onDesignImage((IImage)image, (Object)context);
                    break;
                }
                case 1: {
                    result = handler.onDocImage((IImage)image, (Object)context);
                    break;
                }
                case 2: {
                    result = handler.onURLImage((IImage)image, (Object)context);
                    break;
                }
                case 3: {
                    result = handler.onFileImage((IImage)image, (Object)context);
                    break;
                }
                case 4: {
                    result = handler.onCustomImage((IImage)image, (Object)context);
                    break;
                }
                case -1: {
                    result = "";
                }
            }
            if (result != null && result.length() > 0) {
                HTMLServerImageHandlerTest.assertTrue((boolean)this.isValid(result));
            }
            ++index;
        }
    }

    public void testOnDocImage() {
        HTMLServerImageHandler handler = new HTMLServerImageHandler();
        String result = handler.onDocImage(null, null);
        HTMLServerImageHandlerTest.assertNull((Object)result);
    }

    public void testOnURLImage() {
        try {
            HTMLRenderContext context = new HTMLRenderContext();
            context.setImageDirectory("");
            Image image = new Image("https://mail.google.com/mail/help/images/logo1.gif");
            HTMLServerImageHandler handler = new HTMLServerImageHandler();
            String urlString = handler.onURLImage((IImage)image, (Object)context);
            URL url = this.runnable.getDesignHandle().getModule().findResource(urlString, 1);
            InputStream inputStream = url.openConnection().getInputStream();
            int availableBytes = inputStream.available();
            assert (availableBytes > 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HTMLServerImageHandlerTest.fail();
        }
    }

    public void testOnFileImage() {
    }

    public void testoOnCustomImage() {
    }

    public void testOnDesignImage() {
        HTMLRenderContext context = new HTMLRenderContext();
        context.setImageDirectory(".");
        context.setBaseImageURL(".");
        Image image = (Image)this.runnable.getImage("img.jpg");
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        HTMLServerImageHandler imageHandler = new HTMLServerImageHandler();
        String resultPath = imageHandler.onDesignImage((IImage)image, (Object)context);
        File resultFile = new File(resultPath);
        HTMLServerImageHandlerTest.assertTrue((boolean)resultFile.exists());
        HTMLServerImageHandlerTest.assertTrue((resultFile.length() > 0L ? 1 : 0) != 0);
        this.removeFile(resultPath);
    }

    private boolean isFileAbsolute(String path) {
        assert (path != null);
        return new File(path).isAbsolute();
    }

    private boolean isValid(String path) {
        String[] URL_PREFIXS = new String[]{"http:", "https:"};
        if (path.startsWith(URL_PREFIXS[0]) || path.startsWith(URL_PREFIXS[1])) {
            return true;
        }
        return this.isFileAbsolute(path);
    }
}

