/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;

public class ParameterConverterTest
extends TestCase {
    public void testStringFormat() {
        ULocale locDef = ULocale.getDefault();
        ReportParameterConverter rpc = new ReportParameterConverter("@@@@", locDef);
        ParameterConverterTest.assertEquals((String)"1234fggggg", (String)rpc.format((Object)"1234fggggg"));
        rpc = new ReportParameterConverter("@@@@!", locDef);
        ParameterConverterTest.assertEquals((String)"1234fggggg", (String)rpc.format((Object)"1234fggggg"));
        rpc = new ReportParameterConverter("@@@@!", locDef);
        ParameterConverterTest.assertEquals((String)"123 ", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@@@!!!", locDef);
        ParameterConverterTest.assertEquals((String)"123 ", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@@@", locDef);
        ParameterConverterTest.assertEquals((String)"123456", (String)rpc.format((Object)"123456"));
        rpc = new ReportParameterConverter("@@@@!", locDef);
        ParameterConverterTest.assertEquals((String)"123456", (String)rpc.format((Object)"123456"));
        rpc = new ReportParameterConverter("(@@)@@@", locDef);
        ParameterConverterTest.assertEquals((String)"(  )123", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("&&&&!", locDef);
        ParameterConverterTest.assertEquals((String)"123", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("&&&&&&", locDef);
        ParameterConverterTest.assertEquals((String)"123", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@@&!", locDef);
        ParameterConverterTest.assertEquals((String)"123", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("&@@@&!", locDef);
        ParameterConverterTest.assertEquals((String)"123 ", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@@&", locDef);
        ParameterConverterTest.assertEquals((String)" 123", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@@@@aaa!", locDef);
        ParameterConverterTest.assertEquals((String)"123  aaa", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@aaa!", locDef);
        ParameterConverterTest.assertEquals((String)"12aaa3", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@aaa&&&!", locDef);
        ParameterConverterTest.assertEquals((String)"12aaa3", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@@@@aaa>!", locDef);
        ParameterConverterTest.assertEquals((String)"123  aaa", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@@@<!", locDef);
        ParameterConverterTest.assertEquals((String)"1234fggggg", (String)rpc.format((Object)"1234fggggg"));
        rpc = new ReportParameterConverter("@@@@<!", locDef);
        ParameterConverterTest.assertEquals((String)"1234fggggg", (String)rpc.format((Object)"1234fggGgG"));
        rpc = new ReportParameterConverter("@@@@>!", locDef);
        ParameterConverterTest.assertEquals((String)"1234FGGGGG", (String)rpc.format((Object)"1234fggggg"));
        rpc = new ReportParameterConverter("@@@@&&&>!", locDef);
        ParameterConverterTest.assertEquals((String)"1234FGGGGG", (String)rpc.format((Object)"1234fggggg"));
        rpc = new ReportParameterConverter("@@@@&&@@@<<<>>>@@@&>", locDef);
        ParameterConverterTest.assertEquals((String)"   1234FGGGGG", (String)rpc.format((Object)"1234fggggg"));
        rpc = new ReportParameterConverter("!", locDef);
        ParameterConverterTest.assertEquals((String)"123", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("", locDef);
        ParameterConverterTest.assertEquals((String)"123", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter(">", locDef);
        ParameterConverterTest.assertEquals((String)"123AAA", (String)rpc.format((Object)"123aaA"));
        rpc = new ReportParameterConverter("***\"!", locDef);
        ParameterConverterTest.assertEquals((String)"***\"123", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("***&YY&&&!", locDef);
        ParameterConverterTest.assertEquals((String)"***1YY23", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("***&YY@@@!", locDef);
        ParameterConverterTest.assertEquals((String)"***1YY23 ", (String)rpc.format((Object)"123"));
        rpc = new ReportParameterConverter("@@@-@@-@@@@!", locDef);
        ParameterConverterTest.assertEquals((String)"600-00-03274", (String)rpc.format((Object)"6000003274"));
        rpc = new ReportParameterConverter("@@@@@-@@@@!", locDef);
        ParameterConverterTest.assertEquals((String)"94305-0110", (String)rpc.format((Object)"943050110"));
        rpc = new ReportParameterConverter("@@@@@-@@@@", locDef);
        ParameterConverterTest.assertEquals((String)"94305-0110", (String)rpc.format((Object)"943050110"));
        rpc = new ReportParameterConverter("@@@@@!", locDef);
        ParameterConverterTest.assertEquals((String)"94305", (String)rpc.format((Object)"94305"));
        rpc = new ReportParameterConverter("@@@@@", locDef);
        ParameterConverterTest.assertEquals((String)"94305", (String)rpc.format((Object)"94305"));
        rpc = new ReportParameterConverter("(@@@)-@@@-@@@@!", locDef);
        ParameterConverterTest.assertEquals((String)"(650)-837-2345,", (String)rpc.format((Object)"6508372345,"));
        rpc = new ReportParameterConverter("(@@@)-@@@-@@@@", locDef);
        ParameterConverterTest.assertEquals((String)"(650)-837-2345", (String)rpc.format((Object)"6508372345"));
    }

    public void testDateFormat() {
        ULocale locDef = ULocale.getDefault();
        ULocale locale = new ULocale("en", "us");
        Calendar dateCal = Calendar.getInstance(locDef.toLocale());
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date date = dateCal.getTime();
        locale = ULocale.ITALY;
        ReportParameterConverter rpc = new ReportParameterConverter("MM/dd/yy KK:mm aa", locale);
        ParameterConverterTest.assertEquals((String)"09/13/98 08:01 p.", (String)rpc.format((Object)date));
        rpc = new ReportParameterConverter("Long Date", locale);
        ParameterConverterTest.assertEquals((String)"13 settembre 1998", (String)rpc.format((Object)date));
        locale = new ULocale("en", "us");
        dateCal = Calendar.getInstance(locDef.toLocale());
        dateCal.set(1998, 8, 13, 20, 1, 44);
        date = dateCal.getTime();
        rpc = new ReportParameterConverter("MM/dd/yyyy hh:mm:ss a", locale);
        ParameterConverterTest.assertEquals((String)"09/13/1998 08:01:44 PM", (String)rpc.format((Object)date));
        dateCal = Calendar.getInstance(locDef.toLocale());
        dateCal.set(1998, 8, 13, 20, 1, 44);
        date = dateCal.getTime();
        locale = new ULocale("en", "us");
        rpc = new ReportParameterConverter("Long Date", locale);
        ParameterConverterTest.assertEquals((String)"September 13, 1998", (String)rpc.format((Object)date));
        rpc = new ReportParameterConverter("D", locale);
        ParameterConverterTest.assertEquals((String)"September 13, 1998", (String)rpc.format((Object)date));
        rpc = new ReportParameterConverter("Medium Date", locale);
        ParameterConverterTest.assertEquals((String)"Sep 13, 1998", (String)rpc.format((Object)date));
        rpc = new ReportParameterConverter("Short Date", locale);
        ParameterConverterTest.assertEquals((String)"9/13/98", (String)rpc.format((Object)date));
        rpc = new ReportParameterConverter("d", locale);
        ParameterConverterTest.assertEquals((String)"9/13/98", (String)rpc.format((Object)date));
        rpc = new ReportParameterConverter("Long Time", locale);
        ParameterConverterTest.assertEquals((boolean)true, (boolean)rpc.format((Object)date).startsWith("8:01:44 PM GMT"));
        rpc = new ReportParameterConverter("T", locale);
        ParameterConverterTest.assertEquals((boolean)true, (boolean)rpc.format((Object)date).startsWith("8:01:44 PM GMT"));
        SimpleDateFormat javaSample = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 3, locale.toLocale());
        rpc = new ReportParameterConverter("f", locale);
        ParameterConverterTest.assertEquals((String)javaSample.format(date), (String)rpc.format((Object)date));
        rpc = new ReportParameterConverter("General Date", locale);
        ParameterConverterTest.assertEquals((boolean)true, (boolean)rpc.format((Object)date).startsWith("September 13, 1998 8:01:44 PM GMT"));
        rpc = new ReportParameterConverter("Short Time", locale);
        ParameterConverterTest.assertEquals((String)"20:01", (String)rpc.format((Object)date));
        rpc = new ReportParameterConverter("Medium Time", locale);
        ParameterConverterTest.assertEquals((String)"8:01:44 PM", (String)rpc.format((Object)date));
    }

    public void testOtherFormat() {
        ULocale locDef = ULocale.getDefault();
        NumberFormat number = NumberFormat.getInstance(Locale.getDefault());
        number.setGroupingUsed(false);
        ReportParameterConverter rpc = new ReportParameterConverter(null, locDef.toLocale());
        ParameterConverterTest.assertEquals((String)number.format(1002.234), (String)rpc.format((Object)new Double(1002.234)));
        rpc = new ReportParameterConverter("#", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1002", (String)rpc.format((Object)new Double(1002.2)));
        rpc = new ReportParameterConverter("0", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1002", (String)rpc.format((Object)new Double(1002.2)));
        rpc = new ReportParameterConverter("###,##0", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1,002", (String)rpc.format((Object)new Double(1002.2)));
        rpc = new ReportParameterConverter("#.0#", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1002.2", (String)rpc.format((Object)new Double(1002.2)));
        rpc = new ReportParameterConverter("###,##0.00 'm/s'", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1,002.20 m/s", (String)rpc.format((Object)new Double(1002.2)));
        rpc = new ReportParameterConverter("#.##", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1002", (String)rpc.format((Object)new Long(1002L)));
        rpc = new ReportParameterConverter("###.#';'", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1002.2;", (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)"-1002.2;", (String)rpc.format((Object)new Double(-1002.2)));
        rpc = new ReportParameterConverter("###.#';';#", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1002.2;", (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)"1002.2", (String)rpc.format((Object)new Double(-1002.2)));
        rpc = new ReportParameterConverter("#.00%", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1002200.00%", (String)rpc.format((Object)new Long(10022L)));
        rpc = new ReportParameterConverter("General Number", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)number.format(1002.2), (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)number.format(-1002.2), (String)rpc.format((Object)new Double(-1002.2)));
        ParameterConverterTest.assertEquals((String)number.format(0.004), (String)rpc.format((Object)new Double(0.004)));
        ParameterConverterTest.assertEquals((String)number.format(0.004123456), (String)rpc.format((Object)new Double(0.004123456)));
        ParameterConverterTest.assertEquals((String)number.format(-0.004), (String)rpc.format((Object)new Double(-0.004)));
        ParameterConverterTest.assertEquals((String)number.format(0L), (String)rpc.format((Object)new Long(0L)));
        number = NumberFormat.getCurrencyInstance(Locale.getDefault());
        rpc = new ReportParameterConverter("C", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)number.format(1290.8889), (String)rpc.format((Object)new Double(1290.8889)));
        rpc = new ReportParameterConverter("Fixed", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1002.20", (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)"-1002.20", (String)rpc.format((Object)new Double(-1002.2)));
        ParameterConverterTest.assertEquals((String)"0.00", (String)rpc.format((Object)new Double(0.004)));
        ParameterConverterTest.assertEquals((String)"3333333333.33", (String)rpc.format((Object)new Double(3.33333333333E9)));
        ParameterConverterTest.assertEquals((String)"0.00", (String)rpc.format((Object)new Double(0.0)));
        rpc = new ReportParameterConverter("Standard", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1,002.20", (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)"-1,002.20", (String)rpc.format((Object)new Double(-1002.2)));
        ParameterConverterTest.assertEquals((String)"0.00", (String)rpc.format((Object)new Double(0.004)));
        ParameterConverterTest.assertEquals((String)"0.00", (String)rpc.format((Object)new Double(0.004123456)));
        ParameterConverterTest.assertEquals((String)"0.00", (String)rpc.format((Object)new Double(-0.004)));
        ParameterConverterTest.assertEquals((String)"3,333,333,333.33", (String)rpc.format((Object)new Double(3.33333333333E9)));
        ParameterConverterTest.assertEquals((String)"0.00", (String)rpc.format((Object)new Long(0L)));
        rpc = new ReportParameterConverter("Percent", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"100220.00%", (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)"-100220.00%", (String)rpc.format((Object)new Double(-1002.2)));
        ParameterConverterTest.assertEquals((String)"0.40%", (String)rpc.format((Object)new Double(0.004)));
        ParameterConverterTest.assertEquals((String)"0.41%", (String)rpc.format((Object)new Double(0.004123456)));
        ParameterConverterTest.assertEquals((String)"-0.40%", (String)rpc.format((Object)new Double(-0.004)));
        ParameterConverterTest.assertEquals((String)"333333333333.00%", (String)rpc.format((Object)new Double(3.33333333333E9)));
        ParameterConverterTest.assertEquals((String)"0.00%", (String)rpc.format((Object)new Double(0.0)));
        rpc = new ReportParameterConverter("P", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"100,220.00 %", (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)"-100,220.00 %", (String)rpc.format((Object)new Double(-1002.2)));
        ParameterConverterTest.assertEquals((String)"0.40 %", (String)rpc.format((Object)new Double(0.004)));
        ParameterConverterTest.assertEquals((String)"0.41 %", (String)rpc.format((Object)new Double(0.004123456)));
        ParameterConverterTest.assertEquals((String)"-0.40 %", (String)rpc.format((Object)new Double(-0.004)));
        ParameterConverterTest.assertEquals((String)"333,333,333,333.00 %", (String)rpc.format((Object)new Double(3.33333333333E9)));
        ParameterConverterTest.assertEquals((String)"0.00 %", (String)rpc.format((Object)new Double(0.0)));
        rpc = new ReportParameterConverter("Scientific", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1.00E03", (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)"-1.00E03", (String)rpc.format((Object)new Double(-1002.2)));
        ParameterConverterTest.assertEquals((String)"4.00E-03", (String)rpc.format((Object)new Double(0.004)));
        ParameterConverterTest.assertEquals((String)"4.12E-03", (String)rpc.format((Object)new Double(0.004123456)));
        ParameterConverterTest.assertEquals((String)"-4.00E-03", (String)rpc.format((Object)new Double(-0.004)));
        ParameterConverterTest.assertEquals((String)"3.33E09", (String)rpc.format((Object)new Double(3.33333333333E9)));
        ParameterConverterTest.assertEquals((String)"0.00E00", (String)rpc.format((Object)new Long(0L)));
        ParameterConverterTest.assertEquals((String)"1.00E00", (String)rpc.format((Object)new Long(1L)));
        rpc = new ReportParameterConverter("e", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1.002200E03", (String)rpc.format((Object)new Double(1002.2)));
        ParameterConverterTest.assertEquals((String)"-1.002200E03", (String)rpc.format((Object)new Double(-1002.2)));
        ParameterConverterTest.assertEquals((String)"4.000000E-03", (String)rpc.format((Object)new Double(0.004)));
        ParameterConverterTest.assertEquals((String)"4.123456E-03", (String)rpc.format((Object)new Double(0.004123456)));
        ParameterConverterTest.assertEquals((String)"-4.000000E-03", (String)rpc.format((Object)new Double(-0.004)));
        ParameterConverterTest.assertEquals((String)"3.333333E09", (String)rpc.format((Object)new Double(3.33333333333E9)));
        ParameterConverterTest.assertEquals((String)"0.000000E00", (String)rpc.format((Object)new Long(0L)));
        ParameterConverterTest.assertEquals((String)"1.000000E00", (String)rpc.format((Object)new Long(1L)));
        rpc = new ReportParameterConverter("x", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"3ea", (String)rpc.format((Object)new Long(1002L)));
        ParameterConverterTest.assertEquals((String)"fffffffffffffc16", (String)rpc.format((Object)new Long(-1002L)));
        ParameterConverterTest.assertEquals((String)"3ea", (String)rpc.format((Object)new Double(1002.22)));
        rpc = new ReportParameterConverter("d", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"1,002", (String)rpc.format((Object)new Long(1002L)));
        ParameterConverterTest.assertEquals((String)"-1,002", (String)rpc.format((Object)new Long(-1002L)));
        ParameterConverterTest.assertEquals((String)"1,002.009", (String)rpc.format((Object)new Double(1002.009)));
        rpc = new ReportParameterConverter("$###,##0.00;'Negative'", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"$2,139.30", (String)rpc.format((Object)new BigDecimal(2139.3)));
        ParameterConverterTest.assertEquals((String)"$2.14", (String)rpc.format((Object)new BigDecimal(2.139)));
        ParameterConverterTest.assertEquals((String)"Negative2.13", (String)rpc.format((Object)new BigDecimal(-2.13)));
        ParameterConverterTest.assertEquals((String)"$0.00", (String)rpc.format((Object)new BigDecimal(0.0)));
        ParameterConverterTest.assertEquals((String)"$2,000.00", (String)rpc.format((Object)new BigDecimal(2000)));
        ParameterConverterTest.assertEquals((String)"$20.00", (String)rpc.format((Object)new BigDecimal(20)));
        ParameterConverterTest.assertEquals((String)"Negative2,000.00", (String)rpc.format((Object)new BigDecimal(-2000)));
        ParameterConverterTest.assertEquals((String)"$0.00", (String)rpc.format((Object)new BigDecimal(0)));
        rpc = new ReportParameterConverter("d", locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"2.139", (String)rpc.format((Object)new BigDecimal(2.139)));
        rpc = new ReportParameterConverter(null, locDef.toLocale());
        ParameterConverterTest.assertEquals((String)"true", (String)rpc.format((Object)new Boolean(true)));
        ParameterConverterTest.assertEquals((String)"false", (String)rpc.format((Object)new Boolean(false)));
    }

    public void testParseToString() {
        ULocale locDef = ULocale.getDefault();
        ReportParameterConverter rpc = new ReportParameterConverter("@@@@", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"1234fggggg", (Object)rpc.parse("1234fggggg", 1));
        rpc = new ReportParameterConverter("@@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"1234fggggg", (Object)rpc.parse("1234fggggg", 1));
        rpc = new ReportParameterConverter("@@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("123 ", 1));
        rpc = new ReportParameterConverter("@@@@!!!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("123 ", 1));
        rpc = new ReportParameterConverter("@@@@", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123456", (Object)rpc.parse("123456", 1));
        rpc = new ReportParameterConverter("@@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123456", (Object)rpc.parse("123456", 1));
        rpc = new ReportParameterConverter("(@@)@@@", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("(  )123", 1));
        rpc = new ReportParameterConverter("(&&)@@@", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"  123", (Object)rpc.parse("(  )123", 1));
        rpc = new ReportParameterConverter("&&&&!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123 ", (Object)rpc.parse("123", 1));
        rpc = new ReportParameterConverter("&&&&&&", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"   123", (Object)rpc.parse("123", 1));
        rpc = new ReportParameterConverter("@@@&!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123 ", (Object)rpc.parse("123", 1));
        rpc = new ReportParameterConverter("@@@&", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse(" 123", 1));
        rpc = new ReportParameterConverter("@@@@@aaa!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("123  aaa", 1));
        rpc = new ReportParameterConverter("@@@&&aaa!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123  ", (Object)rpc.parse("123  aaa", 1));
        rpc = new ReportParameterConverter("@@aaa!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("12aaa3", 1));
        rpc = new ReportParameterConverter("@@@@@aaa>!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("123", 1));
        rpc = new ReportParameterConverter("@@@@<!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"1234fggggg", (Object)rpc.parse("1234fggggg", 1));
        rpc = new ReportParameterConverter("@@@@<!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"1234fggGgG", (Object)rpc.parse("1234fggGgG", 1));
        rpc = new ReportParameterConverter("@@@@>!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"1234fggggg", (Object)rpc.parse("1234fggggg", 1));
        rpc = new ReportParameterConverter("@@@@&&&>!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"1234fggggg", (Object)rpc.parse("1234fggggg", 1));
        rpc = new ReportParameterConverter("@@@@&&@@@<<<>>>@@@&>", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"1234fggggg", (Object)rpc.parse("1234fggggg", 1));
        rpc = new ReportParameterConverter("!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("123", 1));
        rpc = new ReportParameterConverter("", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("123", 1));
        rpc = new ReportParameterConverter(">", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123aaA", (Object)rpc.parse("123aaA", 1));
        rpc = new ReportParameterConverter("***\"!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("***\"123", 1));
        rpc = new ReportParameterConverter("***&YY&&&!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123 ", (Object)rpc.parse("***1YY23", 1));
        rpc = new ReportParameterConverter("***&YY@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"123", (Object)rpc.parse("***1YY23 ", 1));
        rpc = new ReportParameterConverter("@@@-@@-@@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"6000003274", (Object)rpc.parse("600-00-03274", 1));
        rpc = new ReportParameterConverter("@@@@@-@@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"943050110", (Object)rpc.parse("94305-0110", 1));
        rpc = new ReportParameterConverter("@@@@@-@@@@", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"943050110", (Object)rpc.parse("94305-0110", 1));
        rpc = new ReportParameterConverter("@@@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"94305", (Object)rpc.parse("94305", 1));
        rpc = new ReportParameterConverter("@@@@@", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"94305", (Object)rpc.parse("94305", 1));
        rpc = new ReportParameterConverter("(@@@)-@@@-@@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"6508372345", (Object)rpc.parse("(650)-837-2345", 1));
        rpc = new ReportParameterConverter("(@@@)-@@@-@@@@", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"6508372345", (Object)rpc.parse("(650)-837-2345", 1));
        rpc = new ReportParameterConverter("(@@@)-@@@-@@@@!", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"65083723456", (Object)rpc.parse("(650)-837-23456", 1));
        rpc = new ReportParameterConverter("(@@@)-@@@-@@@@", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)"346508372345", (Object)rpc.parse("34(650)-837-2345", 1));
    }

    public void testParseToDate() {
        ULocale locDef = ULocale.getDefault();
        ULocale locale = new ULocale("en", "us");
        Calendar dateCal = Calendar.getInstance(locDef.toLocale());
        dateCal.clear();
        dateCal.set(1998, 8, 13, 20, 1, 0);
        Date date = dateCal.getTime();
        locale = ULocale.ITALY;
        ReportParameterConverter rpc = new ReportParameterConverter("MM/dd/yy KK:mm aa", locale);
        ParameterConverterTest.assertEquals((Object)date, (Object)rpc.parse("09/13/98 08:01 p.", 4));
        locale = new ULocale("en", "us");
        dateCal = Calendar.getInstance(locDef.toLocale());
        dateCal.clear();
        dateCal.set(1998, 8, 13, 0, 0, 0);
        date = dateCal.getTime();
        locale = ULocale.ITALY;
        rpc = new ReportParameterConverter("Long Date", locale);
        ParameterConverterTest.assertEquals((Object)date, (Object)rpc.parse("13 settembre 1998", 4));
        locale = new ULocale("en", "us");
        dateCal = Calendar.getInstance(locDef.toLocale());
        dateCal.clear();
        dateCal.set(1998, 8, 13, 20, 1, 44);
        date = dateCal.getTime();
        rpc = new ReportParameterConverter("MM/dd/yyyy hh:mm:ss a", locale);
        ParameterConverterTest.assertEquals((Object)date, (Object)rpc.parse("09/13/1998 08:01:44 PM", 4));
        String date1 = "2005/05/06 03:45:25";
        ReportParameterConverter converter = new ReportParameterConverter("yyyy/MM/dd hh:mm:ss", Locale.US);
        ParameterConverterTest.assertEquals((String)"2005-05-06", (String)converter.parse(date1, 7).toString());
        ParameterConverterTest.assertEquals((String)"03:45:25", (String)converter.parse(date1, 8).toString());
    }

    public void testParseToOther() {
        ULocale locDef = ULocale.getDefault();
        ReportParameterConverter rpc = new ReportParameterConverter("#.0#", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)new Double(1002.2), (Object)rpc.parse("1002.2", 2));
        rpc = new ReportParameterConverter("$###,##0.00;'Negative'", locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)new BigDecimal("2139.3"), (Object)rpc.parse("$2,139.30", 3));
        ParameterConverterTest.assertEquals((Object)new BigDecimal(-2000), (Object)rpc.parse("Negative2,000.00", 3));
        ParameterConverterTest.assertEquals((Object)new BigDecimal(2000), (Object)rpc.parse("$2,000.00", 3));
        ParameterConverterTest.assertEquals((Object)new BigDecimal("-2.13"), (Object)rpc.parse("Negative2.13", 3));
        rpc = new ReportParameterConverter(null, locDef.toLocale());
        ParameterConverterTest.assertEquals((Object)new Boolean(true), (Object)rpc.parse("true", 5));
        ParameterConverterTest.assertEquals((Object)new Boolean(false), (Object)rpc.parse("false", 5));
    }

    public void testBigDecimal() {
        ULocale locale = ULocale.FRENCH;
        ReportParameterConverter rpc = new ReportParameterConverter(null, locale.toLocale());
        ParameterConverterTest.assertEquals((Object)new BigDecimal("123456.789012"), (Object)rpc.parse("123456,789012", 3));
        ParameterConverterTest.assertEquals((String)"123456,789012", (String)rpc.format((Object)new BigDecimal("123456.789012")));
        locale = ULocale.US;
        rpc = new ReportParameterConverter(null, locale.toLocale());
        ParameterConverterTest.assertEquals((Object)new BigDecimal("123456.789012"), (Object)rpc.parse("123456.789012", 3));
        ParameterConverterTest.assertEquals((String)"123456.789012", (String)rpc.format((Object)new BigDecimal("123456.789012")));
    }

    public void testFloat() {
        ULocale locale = ULocale.FRENCH;
        ReportParameterConverter rpc = new ReportParameterConverter(null, locale.toLocale());
        ParameterConverterTest.assertEquals((Object)new Double("123456.789012"), (Object)rpc.parse("123456,789012", 2));
        ParameterConverterTest.assertEquals((String)"123456,789012", (String)rpc.format((Object)new Double("123456.789012")));
        locale = ULocale.US;
        rpc = new ReportParameterConverter(null, locale.toLocale());
        ParameterConverterTest.assertEquals((Object)new Double("123456.789012"), (Object)rpc.parse("123456.789012", 2));
        ParameterConverterTest.assertEquals((String)"123456.789012", (String)rpc.format((Object)new Double("123456.789012")));
    }
}

