/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class RelativeHyperlinkInReportDocumentTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/empty_page.rptdesign";
    static final String REPORT_DESIGN = "relative_hyperlink.rptdesign";
    static final String REPORT_DOCUMENT = "./folder/reportdocument.rptdocument";
    protected IReportEngine engine;

    public void setUp() {
        this.removeFile(REPORT_DOCUMENT);
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.engine = this.createReportEngine();
    }

    public void tearDown() {
        this.engine.shutdown();
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
    }

    public void testRelativeHyperlink() throws Exception {
        IReportRunnable design = this.engine.openReportDesign(REPORT_DESIGN);
        String designId = ((ReportDesignHandle)design.getDesignHandle()).getSystemId().toString();
        IRunTask runTask = this.engine.createRunTask(design);
        runTask.run(REPORT_DOCUMENT);
        runTask.close();
        IReportDocument document = this.engine.openReportDocument(null, REPORT_DOCUMENT);
        IReportRunnable docDesign = document.getReportRunnable();
        String documentId = ((ReportDesignHandle)docDesign.getDesignHandle()).getSystemId().toString();
        document.close();
        RelativeHyperlinkInReportDocumentTest.assertEquals((String)designId, (String)documentId);
    }
}

