/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.TableHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportletTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/reportlet.rptdesign";
    static final String REPORT_DESIGN_RESOURCE2 = "org/eclipse/birt/report/engine/api/reportlet1.rptdesign";

    public void setUp() {
        this.removeFile("reportdocument");
        this.removeFile("design.rptdesign");
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.engine = this.createReportEngine();
    }

    public void tearDown() {
        this.engine.shutdown();
        this.removeFile("design.rptdesign");
        this.removeFile("reportdocument");
    }

    public void testReportlet() throws Exception {
        ArrayList<InstanceID> iidList = new ArrayList<InstanceID>();
        IReportRunnable runnable = this.engine.openReportDesign("design.rptdesign");
        IRunTask task = this.engine.createRunTask(runnable);
        task.run("reportdocument");
        task.close();
        IReportDocument document = this.engine.openReportDocument("reportdocument");
        IRenderTask render = this.engine.createRenderTask(document);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputStream((OutputStream)ostream);
        option.setEnableMetadata(true);
        render.setRenderOption((IRenderOption)option);
        render.render();
        render.close();
        String content = ostream.toString("utf-8");
        Pattern iidPattern = Pattern.compile("iid=\"([^\"]*)\"");
        Matcher matcher = iidPattern.matcher(content);
        while (matcher.find()) {
            String strIid = matcher.group(1);
            InstanceID iid = InstanceID.parse((String)strIid);
            long designId = iid.getComponentID();
            runnable = render.getReportRunnable();
            ReportDesignHandle report = (ReportDesignHandle)runnable.getDesignHandle();
            DesignElementHandle element = report.getElementByID(designId);
            if (!(element instanceof TableHandle)) continue;
            iidList.add(iid);
            render = this.engine.createRenderTask(document);
            option = new HTMLRenderOption();
            option.setOutputFormat("html");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            option.setOutputStream((OutputStream)out);
            render.setRenderOption((IRenderOption)option);
            render.setInstanceID(iid.toUniqueString());
            render.render();
            ReportletTest.assertTrue((boolean)render.getErrors().isEmpty());
            render.close();
            ReportletTest.assertTrue((out.toString("utf-8").length() > 2048 ? 1 : 0) != 0);
        }
        int[] goldenPageNumbers = new int[]{1};
        InstanceID iidTemp = (InstanceID)iidList.get(0);
        ReportletTest.assertTrue(((long)goldenPageNumbers[0] == document.getPageNumber(iidTemp) ? 1 : 0) != 0);
        ReportletTest.assertTrue((document.getInstanceOffset(iidTemp) != -1L ? 1 : 0) != 0);
        render.close();
        document.close();
    }

    public void testRenderReportlet() throws Exception {
        this.removeFile("reportdocument");
        this.removeFile("design.rptdesign");
        this.copyResource(REPORT_DESIGN_RESOURCE2, "design.rptdesign");
        this.engine = this.createReportEngine();
        this.createReportDocument();
        this.doRenderReportletTest();
        this.engine.shutdown();
        this.removeFile("design.rptdesign");
        this.removeFile("reportdocument");
    }

    protected void doRenderReportletTest() throws Exception {
        String BOOKMARK_1 = "bookmark1";
        String BOOKMARK_2 = "bookmark2";
        String CONTENT_1 = "test_reportlet_table1";
        String CONTENT_2 = "test_reportlet_table2";
        IReportDocument reportDoc = this.engine.openReportDocument("reportdocument");
        try {
            List bookmarks = reportDoc.getBookmarks();
            ReportletTest.assertEquals((int)2, (int)bookmarks.size());
            ReportletTest.assertTrue((boolean)bookmarks.contains(BOOKMARK_1));
            ReportletTest.assertTrue((boolean)bookmarks.contains(BOOKMARK_2));
            this.testReportletWithBookmark(reportDoc, BOOKMARK_1, CONTENT_1, CONTENT_2);
            this.testReportletWithBookmark(reportDoc, BOOKMARK_2, CONTENT_2, CONTENT_1);
            List<InstanceID> instanceIds = this.getTableInstanceIds();
            ReportletTest.assertEquals((int)2, (int)instanceIds.size());
            this.testReportletWithInstanceId(reportDoc, instanceIds.get(0), CONTENT_1, CONTENT_2);
            this.testReportletWithInstanceId(reportDoc, instanceIds.get(1), CONTENT_2, CONTENT_1);
        }
        finally {
            reportDoc.close();
        }
    }

    private void testReportletWithBookmark(IReportDocument reportDoc, String bookmark, String contain, String notContain) throws EngineException {
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            HTMLRenderOption option = new HTMLRenderOption();
            option.setOutputFormat("html");
            option.setOutputStream((OutputStream)outputStream);
            task.setRenderOption((IRenderOption)option);
            task.setReportlet(bookmark);
            task.render();
            String content = new String(outputStream.toByteArray());
            ReportletTest.assertTrue((boolean)this.contains(content, contain));
            ReportletTest.assertFalse((boolean)this.contains(content, notContain));
        }
        finally {
            task.close();
        }
    }

    private void testReportletWithInstanceId(IReportDocument reportDoc, InstanceID iid, String contain, String notContain) throws EngineException {
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            HTMLRenderOption option = new HTMLRenderOption();
            option.setOutputFormat("html");
            option.setOutputStream((OutputStream)outputStream);
            task.setRenderOption((IRenderOption)option);
            task.setInstanceID(iid);
            task.render();
            String content = new String(outputStream.toByteArray());
            ReportletTest.assertTrue((boolean)this.contains(content, contain));
            ReportletTest.assertFalse((boolean)this.contains(content, notContain));
        }
        finally {
            task.close();
        }
    }

    private boolean contains(String content, String searchString) {
        return content.indexOf(searchString) >= 0;
    }

    private List<InstanceID> getTableInstanceIds() throws EngineException, UnsupportedEncodingException {
        IReportDocument document = this.engine.openReportDocument("reportdocument");
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            IRenderTask render = this.engine.createRenderTask(document);
            try {
                HTMLRenderOption option = new HTMLRenderOption();
                option.setOutputFormat("html");
                option.setOutputStream((OutputStream)ostream);
                option.setEnableMetadata(true);
                render.setRenderOption((IRenderOption)option);
                render.render();
            }
            finally {
                render.close();
            }
            IReportRunnable runnable = document.getReportRunnable();
            ReportDesignHandle report = (ReportDesignHandle)runnable.getDesignHandle();
            ArrayList<InstanceID> result = new ArrayList<InstanceID>();
            String content = ostream.toString("utf-8");
            Pattern iidPattern = Pattern.compile("iid=\"([^\"]*)\"");
            Matcher matcher = iidPattern.matcher(content);
            while (matcher.find()) {
                String strIid = matcher.group(1);
                InstanceID iid = InstanceID.parse((String)strIid);
                long designId = iid.getComponentID();
                DesignElementHandle element = report.getElementByID(designId);
                if (!(element instanceof TableHandle)) continue;
                result.add(iid);
            }
            ArrayList<InstanceID> arrayList = result;
            return arrayList;
        }
        finally {
            document.close();
        }
    }
}

