/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;

public class TimeZoneTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/timeZoneTest.xml";
    static final String TEMP_RESULT = "tempResult.html";
    static final String GOLDENSTRING = "Nov 1, 2007 9:38 AM";

    public void setUp() {
        this.removeFile("reportdocument");
        this.removeFile("design.rptdesign");
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.engine = this.createReportEngine();
    }

    public void tearDown() {
        this.engine.shutdown();
        this.removeFile("design.rptdesign");
        this.removeFile("reportdocument");
    }

    public void testRunAndRenderTask() {
        block2: {
            try {
                IReportRunnable report = this.engine.openReportDesign("design.rptdesign");
                IRunAndRenderTask task = this.engine.createRunAndRenderTask(report);
                task.setLocale(ULocale.US);
                task.setTimeZone(TimeZone.getTimeZone((String)"UTC"));
                HTMLRenderOption option = new HTMLRenderOption();
                option.setOutputFormat("html");
                option.setOutputFileName(TEMP_RESULT);
                task.setRenderOption((IRenderOption)option);
                task.run();
                TimeZoneTest.assertTrue((boolean)this.stringExist(TEMP_RESULT, GOLDENSTRING));
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void testRenderTask() throws Exception {
        this.createReportDocument();
        IReportDocument reportDoc = this.engine.openReportDocument("reportdocument");
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        task.setLocale(ULocale.US);
        task.setTimeZone(TimeZone.getTimeZone((String)"UTC"));
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputFileName(TEMP_RESULT);
        task.setRenderOption((IRenderOption)option);
        task.render();
        TimeZoneTest.assertTrue((boolean)this.stringExist(TEMP_RESULT, GOLDENSTRING));
    }

    private boolean stringExist(String src, String golden) {
        boolean result = false;
        try {
            FileInputStream srcInputStream = new FileInputStream(new File(src));
            assert (srcInputStream != null);
            StringBuffer srcBuffer = new StringBuffer();
            byte[] buffer = new byte[5120];
            int readCount = -1;
            while ((readCount = ((InputStream)srcInputStream).read(buffer)) != -1) {
                srcBuffer.append(new String(buffer, 0, readCount));
            }
            result = srcBuffer.toString().indexOf(golden) != -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result;
    }
}

