/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.document;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class DocumentIRTransferTest
extends EngineCase {
    final String REPORT_DOCUMENT = "./utest/report.rptdocument";
    final String REPORT_DESIGN = "./utest/report.design";
    final String REPORT_DESIGN_SOURCE = "org/eclipse/birt/report/engine/api/document/report.rptdesign";
    final String REPORT_DOCUMENT_V2_1_3 = "org/eclipse/birt/report/engine/api/document/v2_1_3.rptdocument";
    final String REPORT_DOCUMENT_V2_2_1 = "org/eclipse/birt/report/engine/api/document/v2_2_1.rptdocument";
    ReportDesignHandle reportHandle = null;

    public void setUp() throws Exception {
        super.setUp();
        this.copyResource("org/eclipse/birt/report/engine/api/document/report.rptdesign", "./utest/report.design");
    }

    public void tearDown() {
        this.removeFile("./utest/report.rptdocument");
        this.removeFile("./utest/report.design");
    }

    public void testV2_1_3() throws Exception {
        this.copyResource("org/eclipse/birt/report/engine/api/document/v2_1_3.rptdocument", "./utest/report.rptdocument");
        this.doTestDocument();
        super.removeFile("./utest/report.rptdocument");
    }

    public void testV2_2_1() throws Exception {
        this.copyResource("org/eclipse/birt/report/engine/api/document/v2_2_1.rptdocument", "./utest/report.rptdocument");
        this.doTestDocument();
        super.removeFile("./utest/report.rptdocument");
    }

    void doTestDocument() throws Exception {
        IReportRunnable report = this.engine.openReportDesign("./utest/report.design");
        this.reportHandle = (ReportDesignHandle)report.getDesignHandle();
        this.doRenderPages();
        this.doRenderAll();
        this.doRenderReportletWithInstanceID();
        this.doRenderReportletWithBookmark();
        this.doDataExtractionWithInstanceID();
    }

    void doRenderPages() throws Exception {
        IReportDocument document = this.engine.openReportDocument("./utest/report.rptdocument");
        long totalPage = document.getPageCount();
        DocumentIRTransferTest.assertEquals((long)2L, (long)totalPage);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long pageNumber = 1L;
        while (pageNumber <= totalPage) {
            IRenderTask renderTask = this.engine.createRenderTask(document);
            renderTask.getReportRunnable().setDesignHandle(this.reportHandle);
            HTMLRenderOption option = new HTMLRenderOption();
            option.setOutputFormat("html");
            option.setOutputStream((OutputStream)out);
            renderTask.setRenderOption((IRenderOption)option);
            renderTask.setPageNumber(pageNumber);
            renderTask.render();
            DocumentIRTransferTest.assertTrue((boolean)renderTask.getErrors().isEmpty());
            renderTask.close();
            String pageContent = out.toString("UTF-8");
            if (pageNumber == 1L) {
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_table") != -1 ? 1 : 0) != 0);
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("SECOND-PAGE") == -1 ? 1 : 0) != 0);
            } else {
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_table") == -1 ? 1 : 0) != 0);
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("SECOND-PAGE") != -1 ? 1 : 0) != 0);
            }
            out.reset();
            ++pageNumber;
        }
        document.close();
    }

    void doRenderAll() throws Exception {
        IReportDocument document = this.engine.openReportDocument("./utest/report.rptdocument");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IRenderTask renderTask = this.engine.createRenderTask(document);
        renderTask.getReportRunnable().setDesignHandle(this.reportHandle);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputStream((OutputStream)out);
        renderTask.setRenderOption((IRenderOption)option);
        renderTask.render();
        DocumentIRTransferTest.assertTrue((boolean)renderTask.getErrors().isEmpty());
        renderTask.close();
        String pageContent = out.toString("UTF-8");
        DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_table") != -1 ? 1 : 0) != 0);
        DocumentIRTransferTest.assertTrue((pageContent.indexOf("SECOND-PAGE") != -1 ? 1 : 0) != 0);
        document.close();
    }

    void doRenderReportletWithInstanceID() throws Exception {
        IReportDocument document = this.engine.openReportDocument("./utest/report.rptdocument");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IRenderTask renderTask = this.engine.createRenderTask(document);
        renderTask.getReportRunnable().setDesignHandle(this.reportHandle);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputStream((OutputStream)out);
        renderTask.setRenderOption((IRenderOption)option);
        renderTask.render();
        renderTask.close();
        String content = out.toString("UTF-8");
        out.reset();
        Pattern iidPattern = Pattern.compile("iid=\"([^\"]*)\"");
        Matcher matcher = iidPattern.matcher(content);
        while (matcher.find()) {
            int lastIndexOf;
            int indexOf;
            String strIid = matcher.group(1);
            InstanceID iid = InstanceID.parse((String)strIid);
            long designId = iid.getComponentID();
            IReportRunnable runnable = renderTask.getReportRunnable();
            ReportDesignHandle report = (ReportDesignHandle)runnable.getDesignHandle();
            DesignElementHandle element = report.getElementByID(designId);
            if (!(element instanceof TableHandle) && !(element instanceof ListHandle)) continue;
            renderTask = this.engine.createRenderTask(document);
            renderTask.getReportRunnable().setDesignHandle(this.reportHandle);
            renderTask.setRenderOption((IRenderOption)option);
            renderTask.setInstanceID(strIid);
            renderTask.render();
            DocumentIRTransferTest.assertTrue((boolean)renderTask.getErrors().isEmpty());
            renderTask.close();
            String pageContent = out.toString("UTF-8");
            if (element instanceof TableHandle) {
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_table") != -1 ? 1 : 0) != 0);
                indexOf = pageContent.indexOf("reportlet_group");
                lastIndexOf = pageContent.lastIndexOf("reportlet_group");
                DocumentIRTransferTest.assertTrue((indexOf != -1 && lastIndexOf != -1 && indexOf != lastIndexOf ? 1 : 0) != 0);
            } else {
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_table") != -1 ? 1 : 0) != 0);
                indexOf = pageContent.indexOf("reportlet_group");
                lastIndexOf = pageContent.lastIndexOf("reportlet_group");
                DocumentIRTransferTest.assertTrue((indexOf != -1 && lastIndexOf != -1 && indexOf == lastIndexOf ? 1 : 0) != 0);
            }
            out.reset();
        }
        document.close();
    }

    void doRenderReportletWithBookmark() throws Exception {
        IReportDocument document = this.engine.openReportDocument("./utest/report.rptdocument");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputStream((OutputStream)out);
        String[] bookmarks = new String[]{"reportlet_table", "reportlet_group_0", "reportlet_group_1", "reportlet_group_2"};
        int i = 0;
        while (i < bookmarks.length) {
            IRenderTask renderTask = this.engine.createRenderTask(document);
            renderTask.getReportRunnable().setDesignHandle(this.reportHandle);
            renderTask.setRenderOption((IRenderOption)option);
            renderTask.setReportlet(bookmarks[i]);
            renderTask.render();
            DocumentIRTransferTest.assertTrue((boolean)renderTask.getErrors().isEmpty());
            renderTask.close();
            String pageContent = out.toString("UTF-8");
            if (bookmarks[i].equals("reportlet_table")) {
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_table") != -1 ? 1 : 0) != 0);
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_group_0") != -1 ? 1 : 0) != 0);
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_group_1") != -1 ? 1 : 0) != 0);
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_group_2") != -1 ? 1 : 0) != 0);
            } else {
                DocumentIRTransferTest.assertTrue((pageContent.indexOf("reportlet_table") == -1 ? 1 : 0) != 0);
                int indexOf = pageContent.indexOf("reportlet_group");
                int lastIndexOf = pageContent.lastIndexOf("reportlet_group");
                DocumentIRTransferTest.assertTrue((indexOf != -1 && lastIndexOf != -1 && indexOf == lastIndexOf ? 1 : 0) != 0);
            }
            out.reset();
            ++i;
        }
        document.close();
    }

    void doDataExtractionWithInstanceID() throws Exception {
        IReportDocument document = this.engine.openReportDocument("./utest/report.rptdocument");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IRenderTask renderTask = this.engine.createRenderTask(document);
        renderTask.getReportRunnable().setDesignHandle(this.reportHandle);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputStream((OutputStream)out);
        renderTask.setRenderOption((IRenderOption)option);
        renderTask.render();
        renderTask.close();
        String content = out.toString("UTF-8");
        Pattern iidPattern = Pattern.compile("iid=\"([^\"]*)\"");
        Matcher matcher = iidPattern.matcher(content);
        while (matcher.find()) {
            String strIid = matcher.group(1);
            InstanceID iid = InstanceID.parse((String)strIid);
            long designId = iid.getComponentID();
            IReportRunnable runnable = renderTask.getReportRunnable();
            ReportDesignHandle report = (ReportDesignHandle)runnable.getDesignHandle();
            DesignElementHandle element = report.getElementByID(designId);
            if (!(element instanceof TableHandle) && !(element instanceof ListHandle)) continue;
            IDataExtractionTask task = this.engine.createDataExtractionTask(document);
            task.setInstanceID(iid);
            IExtractionResults results = task.extract();
            if (element instanceof TableHandle) {
                DocumentIRTransferTest.assertEquals((int)27, (int)this.getFieldCount(results));
            } else {
                DocumentIRTransferTest.assertEquals((int)6, (int)this.getFieldCount(results));
            }
            task.close();
        }
        document.close();
    }

    int getFieldCount(IExtractionResults results) throws BirtException {
        int fieldCount = 0;
        IDataIterator iter = results.nextResultIterator();
        IResultMetaData metaData = iter.getResultMetaData();
        int columnCount = metaData.getColumnCount();
        while (iter.next()) {
            fieldCount += columnCount;
        }
        return fieldCount;
    }
}

