/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.Collection;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTaskUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class GetParameterDefinitionTaskTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/impl/TestGetParameterTask.xml";
    static final String REPORT_DESIGN = "GetParameterTaskTest.rptdesign";

    public void setUp() throws Exception {
        super.setUp();
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
    }

    public void tearDown() {
        this.removeFile(REPORT_DESIGN);
    }

    public void testParameterWithDataSet() throws SemanticException, EngineException {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        ReportDesignHandle design = (ReportDesignHandle)report.getDesignHandle().getModuleHandle();
        ScalarParameterHandle parameter1 = (ScalarParameterHandle)design.findParameter("NewParameter2");
        parameter1.setDataSetName("Data Set1");
        ScalarParameterHandle parameter2 = (ScalarParameterHandle)design.findParameter("NewParameter3");
        parameter2.setDataSetName("Data Set");
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(report);
        Collection list = task.getSelectionListForCascadingGroup("NewCascadingParameterGroup", new Object[0]);
        Object[] content = list.toArray();
        GetParameterDefinitionTaskTest.assertEquals((Object)"1,002", (Object)GetParameterDefinitionTaskUtil.SelectionChoiceUtil.getValue((Object)content[0]));
        list = task.getSelectionListForCascadingGroup("NewCascadingParameterGroup", new Object[]{"1002"});
        content = list.toArray();
        GetParameterDefinitionTaskTest.assertEquals((Object)"Atelier graphique", (Object)GetParameterDefinitionTaskUtil.SelectionChoiceUtil.getValue((Object)content[0]));
    }

    public void testSortByOnDatasetColumn() throws EngineException, SemanticException {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(report);
        Collection list = task.getSelectionListForCascadingGroup("SortBysOfSingleDataSet", new Object[0]);
        Object[] content = list.toArray();
        GetParameterDefinitionTaskTest.assertEquals((Object)"USA", (Object)GetParameterDefinitionTaskUtil.SelectionChoiceUtil.getValue((Object)content[1]));
        list = task.getSelectionListForCascadingGroup("SortBysOfSingleDataSet", new Object[]{"USA"});
        content = list.toArray();
        GetParameterDefinitionTaskTest.assertEquals((Object)"MA", (Object)GetParameterDefinitionTaskUtil.SelectionChoiceUtil.getValue((Object)content[1]));
    }
}

