/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.impl.ParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ParameterPromptTextTest
extends EngineCase {
    static final String REPORT_PROMPT_TEXT_SOURCE = "org/eclipse/birt/report/engine/api/impl/prompt_text.xml";
    static final String REPORT_GROUP_PROMPT_TEXT_SOURCE = "org/eclipse/birt/report/engine/api/impl/parameterGroupDefnPromptText.xml";
    static final String REPORT_PROMPT_TEXT_DESIGN = "prompt_text.rptdesign";
    static final String REPORT_GROUP_PROMPT_TEXT_DESIGN = "parameterGroupDefnPromptText.rptdesign";
    protected ScalarParameterDefn scalarParameter;
    protected ArrayList parameters;

    public void setUp() throws Exception {
        super.setUp();
        this.copyResource(REPORT_PROMPT_TEXT_SOURCE, REPORT_PROMPT_TEXT_DESIGN);
        this.copyResource(REPORT_GROUP_PROMPT_TEXT_SOURCE, REPORT_GROUP_PROMPT_TEXT_DESIGN);
    }

    public void tearDown() {
        this.removeFile(REPORT_PROMPT_TEXT_DESIGN);
        this.removeFile(REPORT_GROUP_PROMPT_TEXT_DESIGN);
    }

    public void testPromptText() throws EngineException {
        IReportRunnable runnable = this.engine.openReportDesign(REPORT_PROMPT_TEXT_DESIGN);
        ReportDesignHandle handle = (ReportDesignHandle)((ReportRunnable)runnable).getDesignHandle();
        GetParameterDefinitionTask paramTask = (GetParameterDefinitionTask)this.engine.createGetParameterDefinitionTask(runnable);
        this.parameters = paramTask.getParameters(handle, true);
        ParameterPromptTextTest.assertTrue((this.parameters != null ? 1 : 0) != 0);
        if (this.parameters != null && this.parameters.size() > 0) {
            ParameterPromptTextTest.assertEquals((String)"testPromptText", (String)((ScalarParameterDefn)this.parameters.get(0)).getPromptText());
        }
    }

    public void testCascadingParameterPromptText() throws EngineException {
        IReportRunnable runnable = this.engine.openReportDesign(REPORT_GROUP_PROMPT_TEXT_DESIGN);
        ReportDesignHandle handle = (ReportDesignHandle)((ReportRunnable)runnable).getDesignHandle();
        GetParameterDefinitionTask paramTask = (GetParameterDefinitionTask)this.engine.createGetParameterDefinitionTask(runnable);
        this.parameters = paramTask.getParameters(handle, true);
        ParameterPromptTextTest.assertTrue((this.parameters != null ? 1 : 0) != 0);
        if (this.parameters != null && this.parameters.size() > 0) {
            int i = 0;
            while (i < this.parameters.size()) {
                IParameterDefnBase parameter = (IParameterDefnBase)this.parameters.get(i);
                if (parameter instanceof ParameterGroupDefn) {
                    ParameterPromptTextTest.assertEquals((String)"testParameterGroupDefnPromptText", (String)((ParameterGroupDefn)parameter).getPromptText());
                }
                ++i;
            }
        }
    }
}

