/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportDocumentTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/impl/test.xml";
    static final String REPORT_DESIGN_RESOURCE_TEMP = "test_temp.xml";
    static final String REPORT_DESIGN = "./test.xml";
    static final String REPORT_DOCUMENT = "./reportdocument";

    public void setUp() throws Exception {
        super.setUp();
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
    }

    public void tearDown() {
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
    }

    public void testDocument() {
        this.createDocument();
        this.checkDocument();
    }

    public void testDesignStream() {
        try {
            IReportRunnable runnable = this.engine.openReportDesign((InputStream)new FileInputStream(new File(REPORT_DESIGN)));
            IRunTask runTask = this.engine.createRunTask(runnable);
            runTask.run(REPORT_DOCUMENT);
            IReportDocument rptDoc = this.engine.openReportDocument(REPORT_DOCUMENT);
            InputStream inputStream = rptDoc.getDesignStream();
            ReportDocumentTest.assertTrue((inputStream != null ? 1 : 0) != 0);
            int streamLength = ((RAInputStream)inputStream).available();
            ReportDocumentTest.assertTrue((streamLength > 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportDocumentTest.fail();
        }
    }

    public void testEmptyDocument() {
        try {
            FileArchiveWriter archive = new FileArchiveWriter(REPORT_DOCUMENT);
            ReportDocumentWriter document = new ReportDocumentWriter(this.engine, (IDocArchiveWriter)archive);
            document.close();
            FileArchiveReader reader = new FileArchiveReader(REPORT_DOCUMENT);
            IReportDocument docReader = this.engine.openReportDocument(null, (IDocArchiveReader)reader, null);
            ReportDocumentTest.assertFalse((boolean)reader.exists("/bookmark"));
            ReportDocumentTest.assertTrue((boolean)docReader.getBookmarks().isEmpty());
            docReader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportDocumentTest.fail();
        }
    }

    protected void createDocument() {
        try {
            FileArchiveWriter archive = new FileArchiveWriter(REPORT_DOCUMENT);
            ReportDocumentWriter document = new ReportDocumentWriter(this.engine, (IDocArchiveWriter)archive);
            ReportRunnable runnable = (ReportRunnable)this.engine.openReportDesign(REPORT_DESIGN);
            Report reportIR = new ReportParser().parse((ReportDesignHandle)runnable.getDesignHandle());
            document.saveDesign(runnable, null);
            document.saveReportIR(reportIR);
            HashMap parameters = this.createParamters();
            document.saveParamters(parameters);
            Map map = this.createPersistentObjects();
            document.savePersistentObjects(map);
            this.createBookmarks(document);
            document.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportDocumentTest.fail();
        }
    }

    protected void checkDocument() {
        try {
            FileArchiveReader archive = new FileArchiveReader(REPORT_DOCUMENT);
            IReportDocument document = this.engine.openReportDocument(null, (IDocArchiveReader)archive, null);
            ReportDocumentTest.assertTrue((document.getName() != null ? 1 : 0) != 0);
            ReportDocumentTest.assertTrue((document.getReportRunnable() != null ? 1 : 0) != 0);
            this.checkParamters(document.getParameterValues());
            this.checkBookmarks(document);
            this.checkPersistentObjects(document.getGlobalVariables(null));
            document.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportDocumentTest.fail();
        }
    }

    protected HashMap createParamters() {
        HashMap<String, ParameterAttribute> paramters = new HashMap<String, ParameterAttribute>();
        ParameterAttribute paa = new ParameterAttribute((Object)new Integer(100), "100");
        ParameterAttribute pab = new ParameterAttribute((Object)new String("STRING"), "STRING");
        paramters.put("A", paa);
        paramters.put("B", pab);
        return paramters;
    }

    protected void checkParamters(Map paramters) {
        ReportDocumentTest.assertEquals((int)2, (int)paramters.size());
        ReportDocumentTest.assertEquals((Object)new Integer(100), paramters.get("A"));
        ReportDocumentTest.assertEquals((Object)"STRING", paramters.get("B"));
    }

    protected Map createPersistentObjects() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("string", "STRING");
        map.put("integer", new Integer(3));
        return map;
    }

    protected void checkPersistentObjects(Map map) {
        ReportDocumentTest.assertEquals((int)2, (int)map.size());
        ReportDocumentTest.assertEquals((Object)"STRING", map.get("string"));
        ReportDocumentTest.assertEquals((Object)new Integer(3), map.get("integer"));
    }

    protected void createBookmarks(ReportDocumentWriter writer) {
        writer.setPageNumberOfBookmark("A", 1L);
        writer.setPageNumberOfBookmark("B", 2L);
    }

    protected void checkBookmarks(IReportDocument document) {
        ReportDocumentTest.assertEquals((long)1L, (long)document.getPageNumber("A"));
        ReportDocumentTest.assertEquals((long)2L, (long)document.getPageNumber("B"));
    }
}

