/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.script.instance;

import com.ibm.icu.util.ULocale;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.report.engine.api.script.IColumnMetaData;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IReportElementInstance;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ListContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.script.internal.instance.CellInstance;
import org.eclipse.birt.report.engine.script.internal.instance.DataItemInstance;
import org.eclipse.birt.report.engine.script.internal.instance.DataSetInstance;
import org.eclipse.birt.report.engine.script.internal.instance.DataSourceInstance;
import org.eclipse.birt.report.engine.script.internal.instance.DynamicTextInstance;
import org.eclipse.birt.report.engine.script.internal.instance.GridInstance;
import org.eclipse.birt.report.engine.script.internal.instance.ImageInstance;
import org.eclipse.birt.report.engine.script.internal.instance.LabelInstance;
import org.eclipse.birt.report.engine.script.internal.instance.ListInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RowInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.engine.script.internal.instance.StyleInstance;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.mozilla.javascript.Scriptable;

public class InstanceTest
extends TestCase {
    private static final String TYPE_NAME_2 = "type2";
    private static final String TYPE_NAME_1 = "type1";
    private static final String NATIVE2 = "native2";
    private static final String NATIVE1 = "native1";
    private static final String NAME2 = "name2";
    private static final String NAME1 = "name1";
    private static final String LABEL2 = "label2";
    private static final String LABEL1 = "label1";
    private static final String ALIAS2 = "alias2";
    private static final String ALIAS1 = "alias1";
    private static final String ALT_TEXT_KEY = "altTextKey";
    private static final String ALT_TEXT = "altText";
    private static final String WORD_SPACING = "30px";
    private static final String TEXT_INDENT = "30px";
    private static final String SHOW_IF_BLANK = "true";
    private static final String PADDING_TOP = "23px";
    private static final String PADDING_RIGHT = "22px";
    private static final String PADDING_LEFT = "21px";
    private static final String PADDING_BOTTOM = "20px";
    private static final String MASTER_PAGE = "masterPage";
    private static final String MARGIN_TOP = "13px";
    private static final String MARGIN_RIGHT = "12px";
    private static final String MARGIN_LEFT = "11px";
    private static final String MARGIN_BOTTOM = "10px";
    private static final String LETTER_SPACING = "10px";
    private static final String YY_MM_DD = "YY-MM-DD";
    private static final String WHITE = "white";
    private static final String CAN_SHRINK = "true";
    private static final String BORDER_TOP_WIDTH = "16cm";
    private static final String GRAY = "gray";
    private static final String BORDER_RIGHT_WIDTH = "15cm";
    private static final String YELLOW = "yellow";
    private static final String BORDER_LEFT_WIDTH = "14cm";
    private static final String GREEN = "green";
    private static final String BORDER_BOTTOM_WIDTH = "13cm";
    private static final String BLUE = "blue";
    private static final String BACKGROUND_POS_Y = "11cm";
    private static final String BACKGROUND_POS_X = "10cm";
    private static final String RED = "red";
    private static final String BOOKMARK = "bookmark";
    private static final String LABEL_TEXT = "labelText";
    private static final String URI = "uri";
    private static final String MIME_TYPE = "img/gif";
    private static final String IMAGE_NAME = "imageName";
    private static final String DYNAMIC_TEXT = "text";
    private static final String QUERY_TEXT = "queryText";
    private static final String EXT_PROP_VALUE1 = "propvalue1";
    private static final String EXT_PROP1 = "prop1";
    private static final String USER_PROP_VALUE = "userPropValue";
    private static final String USER_PROP = "userProp";
    private static final String HORIZONTAL_POSITION = "11px";
    private static final String HEIGHT = "10px";
    private static final int COL_SPAN = 2;
    private static final String EXPRESSION_VALUE = "expressionValue";
    private static final String EXPRESSION = "expression";
    private static final String EXTENSION_ID = "extensionId";
    private static final String FAKE_NAME = "fakeName";
    private static final byte[] DATA = new byte[]{123};
    private static final int TYPE_2 = 2;
    private static final int TYPE_1 = 1;
    private static final String IMAGE_FILE = "imageFile";
    private static final String IMAGE_URL = "imageURL";
    private ReportContent reportContent;
    private ElementFactory factory;

    public void setUp() {
        this.reportContent = new ReportContent();
        SessionHandle sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = sessionHandle.createDesign();
        this.factory = new ElementFactory(designHandle.getModule());
    }

    private void doTestReportElementInstance(IReportElementInstance element) throws ScriptException {
        element.setHeight("10px");
        InstanceTest.assertEquals((String)"10px", (String)element.getHeight());
        element.setHorizontalPosition("11px");
        InstanceTest.assertEquals((String)"11px", (String)element.getHorizontalPosition());
        element.setUserPropertyValue(USER_PROP, (Object)USER_PROP_VALUE);
    }

    public void testCellInstance() throws ScriptException {
        CellContent cellContent = (CellContent)this.reportContent.createCellContent();
        cellContent.setColumn(1);
        HashMap<String, String> expressionMap = new HashMap<String, String>();
        expressionMap.put(EXPRESSION, EXPRESSION_VALUE);
        CellInstance cell = new CellInstance((ICellContent)cellContent, null, null, false);
        cell.setColSpan(2);
        InstanceTest.assertEquals((int)2, (int)cell.getColSpan());
    }

    public void testDataItemInstance() throws ScriptException {
        DataContent dataItemContent = (DataContent)this.reportContent.createDataContent();
        DataItemDesign dataItemDesign = new DataItemDesign();
        DataItemHandle dataHandle = this.factory.newDataItem("DataItem");
        dataItemDesign.setHandle((DesignElementHandle)dataHandle);
        dataItemContent.setGenerateBy((Object)dataItemDesign);
        DataItemInstance dataItem = new DataItemInstance((IDataContent)dataItemContent, null, null);
        this.doTestReportElementInstance((IReportElementInstance)dataItem);
    }

    public void testDataSetInstance() throws ScriptException {
        DataSetInstance dataSetInstance = new DataSetInstance((IDataSetInstanceHandle)new FakeDataSetHandle());
        dataSetInstance.setExtensionProperty(EXT_PROP1, EXT_PROP_VALUE1);
        InstanceTest.assertEquals((String)EXT_PROP_VALUE1, (String)dataSetInstance.getExtensionProperty(EXT_PROP1));
        dataSetInstance.setQueryText(QUERY_TEXT);
        InstanceTest.assertEquals((String)QUERY_TEXT, (String)dataSetInstance.getQueryText());
        InstanceTest.assertEquals((String)FAKE_NAME, (String)dataSetInstance.getName());
        InstanceTest.assertEquals((String)EXTENSION_ID, (String)dataSetInstance.getExtensionID());
        IColumnMetaData meta = dataSetInstance.getColumnMetaData();
        InstanceTest.assertEquals((String)ALIAS1, (String)meta.getColumnAlias(1));
        InstanceTest.assertEquals((String)ALIAS2, (String)meta.getColumnAlias(2));
        InstanceTest.assertEquals((String)LABEL1, (String)meta.getColumnLabel(1));
        InstanceTest.assertEquals((String)LABEL2, (String)meta.getColumnLabel(2));
        InstanceTest.assertEquals((String)NAME1, (String)meta.getColumnName(1));
        InstanceTest.assertEquals((String)NAME2, (String)meta.getColumnName(2));
        InstanceTest.assertEquals((String)NATIVE1, (String)meta.getColumnNativeTypeName(1));
        InstanceTest.assertEquals((String)NATIVE2, (String)meta.getColumnNativeTypeName(2));
        InstanceTest.assertEquals((String)TYPE_NAME_1, (String)meta.getColumnTypeName(1));
        InstanceTest.assertEquals((String)TYPE_NAME_2, (String)meta.getColumnTypeName(2));
        InstanceTest.assertTrue((boolean)meta.isComputedColumn(1));
        InstanceTest.assertFalse((boolean)meta.isComputedColumn(2));
        InstanceTest.assertEquals((int)2, (int)meta.getColumnCount());
        InstanceTest.assertEquals((int)1, (int)meta.getColumnType(1));
        InstanceTest.assertEquals((int)2, (int)meta.getColumnType(2));
    }

    public void testDataSourceInstance() throws ScriptException {
        DataSourceInstance dataSourceInstance = new DataSourceInstance((IDataSourceInstanceHandle)new FakeDataSourceHandle());
        dataSourceInstance.setExtensionProperty(EXT_PROP1, EXT_PROP_VALUE1);
        InstanceTest.assertEquals((String)EXT_PROP_VALUE1, (String)dataSourceInstance.getExtensionProperty(EXT_PROP1));
        InstanceTest.assertEquals((String)FAKE_NAME, (String)dataSourceInstance.getName());
        InstanceTest.assertEquals((String)EXTENSION_ID, (String)dataSourceInstance.getExtensionID());
    }

    public void testDynamicTextInstance() throws ScriptException {
        ForeignContent foreignContent = (ForeignContent)this.reportContent.createForeignContent();
        foreignContent.setRawType("text/plaintext");
        DynamicTextInstance textInstance = new DynamicTextInstance((IContent)foreignContent, null, null);
        textInstance.setText(DYNAMIC_TEXT);
        InstanceTest.assertEquals((String)DYNAMIC_TEXT, (String)textInstance.getText());
    }

    public void testGridInstance() throws ScriptException {
        TableContent content = (TableContent)this.reportContent.createTableContent();
        new GridInstance((ITableContent)content, null, null);
    }

    public void testImageInstance() throws ScriptException {
        ImageContent imageContent = (ImageContent)this.reportContent.createImageContent();
        ImageInstance imageInstance = new ImageInstance((IImageContent)imageContent, null, null);
        imageInstance.setAltText(ALT_TEXT);
        InstanceTest.assertEquals((String)ALT_TEXT, (String)imageInstance.getAltText());
        imageInstance.setAltTextKey(ALT_TEXT_KEY);
        InstanceTest.assertEquals((String)ALT_TEXT_KEY, (String)imageInstance.getAltTextKey());
        imageInstance.setData(DATA);
        InstanceTest.assertEquals((Object)DATA, (Object)imageInstance.getData());
        imageInstance.setImageName(IMAGE_NAME);
        InstanceTest.assertEquals((String)IMAGE_NAME, (String)imageInstance.getImageName());
        InstanceTest.assertEquals((int)1, (int)imageInstance.getImageSource());
        imageInstance.setMimeType(MIME_TYPE);
        InstanceTest.assertEquals((String)MIME_TYPE, (String)imageInstance.getMimeType());
        imageInstance.setURL(IMAGE_URL);
        InstanceTest.assertEquals((int)3, (int)imageInstance.getImageSource());
        InstanceTest.assertEquals((String)IMAGE_URL, (String)imageInstance.getURL());
        imageInstance.setFile(IMAGE_FILE);
        InstanceTest.assertEquals((int)0, (int)imageInstance.getImageSource());
        InstanceTest.assertEquals((String)IMAGE_FILE, (String)imageInstance.getFile());
    }

    public void testLabelInstance() throws ScriptException {
        LabelContent labelContent = (LabelContent)this.reportContent.createLabelContent();
        LabelInstance labelInstance = new LabelInstance((ILabelContent)labelContent, null, null);
        labelInstance.setText(LABEL_TEXT);
        InstanceTest.assertEquals((String)LABEL_TEXT, (String)labelInstance.getText());
    }

    public void testListInstance() throws ScriptException {
        ListContent listContent = (ListContent)this.reportContent.createListContent();
        new ListInstance((IListContent)listContent, null, null);
    }

    public void testRowInstance() throws ScriptException {
        RowContent rowContent = (RowContent)this.reportContent.createRowContent();
        HashMap<String, String> expressionMap = new HashMap<String, String>();
        expressionMap.put(EXPRESSION, EXPRESSION_VALUE);
        RowInstance rowInstance = new RowInstance((IRowContent)rowContent, null, null);
        rowInstance.setBookmark(BOOKMARK);
        InstanceTest.assertEquals((String)BOOKMARK, (String)rowInstance.getBookmarkValue());
        rowInstance.setHeight("10px");
        InstanceTest.assertEquals((String)"10px", (String)rowInstance.getHeight());
    }

    public void testScriptStyle() throws ScriptException {
        IStyle style = this.reportContent.createStyle();
        StyleInstance styleInstance = new StyleInstance(style, null);
        styleInstance.setBackgroundAttachment("scroll");
        InstanceTest.assertEquals((String)"scroll", (String)styleInstance.getBackgroundAttachment());
        styleInstance.setBackgroundColor(RED);
        InstanceTest.assertEquals((String)RED, (String)styleInstance.getBackgroundColor());
        styleInstance.setBackgroundImage(URI);
        InstanceTest.assertEquals((String)URI, (String)styleInstance.getBackgroundImage());
        styleInstance.setBackgroundPositionX(BACKGROUND_POS_X);
        InstanceTest.assertEquals((String)BACKGROUND_POS_X, (String)styleInstance.getBackgroundPositionX());
        styleInstance.setBackgroundPositionY(BACKGROUND_POS_Y);
        InstanceTest.assertEquals((String)BACKGROUND_POS_Y, (String)styleInstance.getBackgroundPositionY());
        styleInstance.setBackgroundRepeat("repeat-x");
        InstanceTest.assertEquals((String)"repeat-x", (String)styleInstance.getBackgroundRepeat());
        styleInstance.setBorderBottomColor(BLUE);
        InstanceTest.assertEquals((String)BLUE, (String)styleInstance.getBorderBottomColor());
        styleInstance.setBorderBottomStyle("solid");
        InstanceTest.assertEquals((String)"solid", (String)styleInstance.getBorderBottomStyle());
        styleInstance.setBorderBottomWidth(BORDER_BOTTOM_WIDTH);
        InstanceTest.assertEquals((String)BORDER_BOTTOM_WIDTH, (String)styleInstance.getBorderBottomWidth());
        styleInstance.setBorderLeftColor(GREEN);
        InstanceTest.assertEquals((String)GREEN, (String)styleInstance.getBorderLeftColor());
        styleInstance.setBorderLeftStyle("dotted");
        InstanceTest.assertEquals((String)"dotted", (String)styleInstance.getBorderLeftStyle());
        styleInstance.setBorderLeftWidth(BORDER_LEFT_WIDTH);
        InstanceTest.assertEquals((String)BORDER_LEFT_WIDTH, (String)styleInstance.getBorderLeftWidth());
        styleInstance.setBorderRightColor(YELLOW);
        InstanceTest.assertEquals((String)YELLOW, (String)styleInstance.getBorderRightColor());
        styleInstance.setBorderRightStyle("dashed");
        InstanceTest.assertEquals((String)"dashed", (String)styleInstance.getBorderRightStyle());
        styleInstance.setBorderRightWidth(BORDER_RIGHT_WIDTH);
        InstanceTest.assertEquals((String)BORDER_RIGHT_WIDTH, (String)styleInstance.getBorderRightWidth());
        styleInstance.setBorderTopColor(GRAY);
        InstanceTest.assertEquals((String)GRAY, (String)styleInstance.getBorderTopColor());
        styleInstance.setBorderTopStyle("double");
        InstanceTest.assertEquals((String)"double", (String)styleInstance.getBorderTopStyle());
        styleInstance.setBorderTopWidth(BORDER_TOP_WIDTH);
        InstanceTest.assertEquals((String)BORDER_TOP_WIDTH, (String)styleInstance.getBorderTopWidth());
        styleInstance.setCanShrink("true");
        InstanceTest.assertEquals((String)"true", (String)styleInstance.getCanShrink());
        styleInstance.setColor(WHITE);
        InstanceTest.assertEquals((String)WHITE, (String)styleInstance.getColor());
        styleInstance.setDateFormat(YY_MM_DD);
        InstanceTest.assertEquals((String)YY_MM_DD, (String)styleInstance.getDateFormat());
        styleInstance.setDisplay("inline");
        InstanceTest.assertEquals((String)"inline", (String)styleInstance.getDisplay());
        styleInstance.setFontFamily("sans-serif");
        InstanceTest.assertEquals((String)"sans-serif", (String)styleInstance.getFontFamily());
        styleInstance.setFontSize("large");
        InstanceTest.assertEquals((String)"large", (String)styleInstance.getFontSize());
        styleInstance.setFontStyle("italic");
        InstanceTest.assertEquals((String)"italic", (String)styleInstance.getFontStyle());
        styleInstance.setFontVariant("small-caps");
        InstanceTest.assertEquals((String)"small-caps", (String)styleInstance.getFontVariant());
        styleInstance.setFontWeight("bold");
        InstanceTest.assertEquals((String)"bold", (String)styleInstance.getFontWeight());
        styleInstance.setLetterSpacing("10px");
        InstanceTest.assertEquals((String)"10px", (String)styleInstance.getLetterSpacing());
        styleInstance.setLineHeight("10px");
        InstanceTest.assertEquals((String)"10px", (String)styleInstance.getLineHeight());
        styleInstance.setMarginBottom("10px");
        InstanceTest.assertEquals((String)"10px", (String)styleInstance.getMarginBottom());
        styleInstance.setMarginLeft("11px");
        InstanceTest.assertEquals((String)"11px", (String)styleInstance.getMarginLeft());
        styleInstance.setMarginRight(MARGIN_RIGHT);
        InstanceTest.assertEquals((String)MARGIN_RIGHT, (String)styleInstance.getMarginRight());
        styleInstance.setMarginTop(MARGIN_TOP);
        InstanceTest.assertEquals((String)MARGIN_TOP, (String)styleInstance.getMarginTop());
        styleInstance.setMasterPage(MASTER_PAGE);
        InstanceTest.assertEquals((String)MASTER_PAGE, (String)styleInstance.getMasterPage());
        styleInstance.setNumberFormat("Currency");
        InstanceTest.assertEquals((String)"Currency", (String)styleInstance.getNumberFormat());
        styleInstance.setPaddingBottom(PADDING_BOTTOM);
        InstanceTest.assertEquals((String)PADDING_BOTTOM, (String)styleInstance.getPaddingBottom());
        styleInstance.setPaddingLeft(PADDING_LEFT);
        InstanceTest.assertEquals((String)PADDING_LEFT, (String)styleInstance.getPaddingLeft());
        styleInstance.setPaddingRight(PADDING_RIGHT);
        InstanceTest.assertEquals((String)PADDING_RIGHT, (String)styleInstance.getPaddingRight());
        styleInstance.setPaddingTop(PADDING_TOP);
        InstanceTest.assertEquals((String)PADDING_TOP, (String)styleInstance.getPaddingTop());
        styleInstance.setPageBreakAfter("always");
        InstanceTest.assertEquals((String)"always", (String)styleInstance.getPageBreakAfter());
        styleInstance.setPageBreakBefore("avoid");
        InstanceTest.assertEquals((String)"avoid", (String)styleInstance.getPageBreakBefore());
        styleInstance.setShowIfBlank("true");
        InstanceTest.assertEquals((String)"true", (String)styleInstance.getShowIfBlank());
        styleInstance.setStringFormat("Zip Code");
        InstanceTest.assertEquals((String)"Zip Code", (String)styleInstance.getStringFormat());
        styleInstance.setTextAlign("right");
        InstanceTest.assertEquals((String)"right", (String)styleInstance.getTextAlign());
        styleInstance.setTextIndent("30px");
        InstanceTest.assertEquals((String)"30px", (String)styleInstance.getTextIndent());
        styleInstance.setTextLineThrough("line-through");
        InstanceTest.assertEquals((String)"line-through", (String)styleInstance.getTextLineThrough());
        styleInstance.setTextOverline("overline");
        InstanceTest.assertEquals((String)"overline", (String)styleInstance.getTextOverline());
        styleInstance.setTextTransform("uppercase");
        InstanceTest.assertEquals((String)"uppercase", (String)styleInstance.getTextTransform());
        styleInstance.setTextUnderline("underline");
        InstanceTest.assertEquals((String)"underline", (String)styleInstance.getTextUnderline());
        styleInstance.setVerticalAlign("top");
        InstanceTest.assertEquals((String)"top", (String)styleInstance.getVerticalAlign());
        styleInstance.setVisibleFormat("all");
        InstanceTest.assertEquals((String)"all", (String)styleInstance.getVisibleFormat());
        styleInstance.setWhiteSpace("nowrap");
        InstanceTest.assertEquals((String)"nowrap", (String)styleInstance.getWhiteSpace());
        styleInstance.setWordSpacing("30px");
        InstanceTest.assertEquals((String)"30px", (String)styleInstance.getWordSpacing());
    }

    public void testPageBreak() throws Throwable {
        IStyle style = this.reportContent.createStyle();
        StyleInstance styleInstance = new StyleInstance(style, RunningState.CREATE);
        styleInstance.setPageBreakAfter("always");
        styleInstance.setPageBreakBefore("always");
        styleInstance.setPageBreakInside("always");
        styleInstance = new StyleInstance(style, RunningState.RENDER);
        this.testMethod(styleInstance, "setPageBreakAfter");
        this.testMethod(styleInstance, "setPageBreakBefore");
        this.testMethod(styleInstance, "setPageBreakInside");
        styleInstance = new StyleInstance(style, RunningState.PAGEBREAK);
        this.testMethod(styleInstance, "setPageBreakAfter");
        this.testMethod(styleInstance, "setPageBreakBefore");
        this.testMethod(styleInstance, "setPageBreakInside");
    }

    private void testMethod(StyleInstance styleInstance, String methodName) throws Throwable {
        try {
            Method method = StyleInstance.class.getMethod(methodName, String.class);
            method.invoke((Object)styleInstance, "always");
            InstanceTest.fail();
        }
        catch (InvocationTargetException expected) {
            Throwable targetException = expected.getTargetException();
            if (targetException instanceof UnsupportedOperationException) {
                InstanceTest.assertTrue((boolean)true);
                return;
            }
            throw targetException;
        }
    }

    private abstract class FakeBaseData {
        private Map extProps = new HashMap();

        private FakeBaseData() {
        }

        public String getName() {
            return InstanceTest.FAKE_NAME;
        }

        public String getExtensionID() {
            return InstanceTest.EXTENSION_ID;
        }

        public String getExtensionProperty(String name) {
            return (String)this.extProps.get(name);
        }

        public void setExtensionProperty(String name, String value) {
            this.extProps.put(name, value);
        }

        public Map getAllExtensionProperties() {
            return this.extProps;
        }

        public Scriptable getScriptScope() {
            return null;
        }
    }

    private class FakeDataSetHandle
    extends FakeBaseData
    implements IDataSetInstanceHandle {
        private String queryText;
        private Map inputParamValues = new HashMap();

        private FakeDataSetHandle() {
        }

        public IDataSourceInstanceHandle getDataSource() {
            return null;
        }

        public IResultMetaData getResultMetaData() throws BirtException {
            return new FakeResultMetadata();
        }

        public String getQueryText() throws BirtException {
            return this.queryText;
        }

        public void setQueryText(String queryText) throws BirtException {
            this.queryText = queryText;
        }

        public Object getInputParameterValue(String paramName) throws BirtException {
            return null;
        }

        public void setInputParameterValue(String paramName, Object paramValue) throws BirtException {
        }

        public Map getInputParameters() {
            return null;
        }

        public Object getOutputParameterValue(String paramName) throws BirtException {
            return null;
        }

        public void setOutputParameterValue(String paramName, Object paramValue) throws BirtException {
        }

        public Map getOutputParameters() {
            return null;
        }
    }

    private class FakeDataSourceHandle
    extends FakeBaseData
    implements IDataSourceInstanceHandle {
        private FakeDataSourceHandle() {
        }
    }

    private class FakeResultMetadata
    implements IResultMetaData {
        private List columns = new ArrayList();

        public FakeResultMetadata() {
            this.columns.add(new Column(InstanceTest.NAME1, InstanceTest.ALIAS1, 1, InstanceTest.TYPE_NAME_1, InstanceTest.NATIVE1, InstanceTest.LABEL1, true));
            this.columns.add(new Column(InstanceTest.NAME2, InstanceTest.ALIAS2, 2, InstanceTest.TYPE_NAME_2, InstanceTest.NATIVE2, InstanceTest.LABEL2, false));
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public String getColumnName(int index) throws BirtException {
            Column c = (Column)this.columns.get(index - 1);
            return c.name;
        }

        public String getColumnAlias(int index) throws BirtException {
            Column c = (Column)this.columns.get(index - 1);
            return c.alias;
        }

        public int getColumnType(int index) throws BirtException {
            Column c = (Column)this.columns.get(index - 1);
            return c.type;
        }

        public String getColumnTypeName(int index) throws BirtException {
            Column c = (Column)this.columns.get(index - 1);
            return c.typeName;
        }

        public String getColumnNativeTypeName(int index) throws BirtException {
            Column c = (Column)this.columns.get(index - 1);
            return c.nativeTypeName;
        }

        public String getColumnLabel(int index) throws BirtException {
            Column c = (Column)this.columns.get(index - 1);
            return c.label;
        }

        public boolean isComputedColumn(int index) throws BirtException {
            Column c = (Column)this.columns.get(index - 1);
            return c.computed;
        }

        private class Column {
            String name;
            String alias;
            int type;
            String typeName;
            String nativeTypeName;
            String label;
            boolean computed;

            public Column(String name, String alias, int type, String typeName, String nativeTypeName, String label, boolean computed) {
                this.name = name;
                this.alias = alias;
                this.type = type;
                this.typeName = typeName;
                this.nativeTypeName = nativeTypeName;
                this.label = label;
                this.computed = computed;
            }
        }
    }
}

