/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.css;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.executor.css.CssParser;

public class CssParserTest
extends TestCase {
    public void testBackground() throws Exception {
        String style = "background: url(\"chess.png\") gray 50% repeat fixed ";
        CssParser parser = new CssParser((Reader)new StringReader(style));
        parser.parse();
        HashMap result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("background-image"), (Object)"url(\"chess.png\")");
        CssParserTest.assertEquals(result.get("background-color"), (Object)"gray");
        CssParserTest.assertEquals(result.get("background-position"), (Object)"50%");
        CssParserTest.assertEquals(result.get("background-repeat"), (Object)"repeat");
        CssParserTest.assertEquals(result.get("background-attachment"), (Object)"fixed");
    }

    public void testFont() throws Exception {
        String style = "font: 12px/14px sans-serif ";
        CssParser parser = new CssParser((Reader)new StringReader(style));
        parser.parse();
        HashMap result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("font-size"), (Object)"12px");
        CssParserTest.assertEquals(result.get("line-height"), (Object)"14px");
        CssParserTest.assertEquals(result.get("font-family"), (Object)"sans-serif");
        parser.ReInit((Reader)new StringReader("font: 80% sans-serif "));
        parser.parse();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("font-size"), (Object)"80%");
        CssParserTest.assertEquals(result.get("font-family"), (Object)"sans-serif");
        parser.ReInit((Reader)new StringReader(" font: x-large/110% \"New Century Schoolbook\", serif "));
        parser.parse();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("font-size"), (Object)"x-large");
        CssParserTest.assertEquals(result.get("line-height"), (Object)"110%");
        CssParserTest.assertEquals(result.get("font-family"), (Object)"\"New Century Schoolbook\",serif");
        parser.ReInit((Reader)new StringReader("font: bold italic large Palatino, serif "));
        parser.parse();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("font-weight"), (Object)"bold");
        CssParserTest.assertEquals(result.get("font-style"), (Object)"italic");
        CssParserTest.assertEquals(result.get("font-size"), (Object)"large");
        CssParserTest.assertEquals(result.get("font-family"), (Object)"Palatino,serif");
        parser.ReInit((Reader)new StringReader("font: normal small-caps 120%/120% fantasy "));
        parser.parse();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("font-weight"), (Object)"normal");
        CssParserTest.assertEquals(result.get("font-style"), (Object)"normal");
        CssParserTest.assertEquals(result.get("font-variant"), (Object)"small-caps");
        CssParserTest.assertEquals(result.get("font-size"), (Object)"120%");
        CssParserTest.assertEquals(result.get("line-height"), (Object)"120%");
        CssParserTest.assertEquals(result.get("font-family"), (Object)"fantasy");
    }

    public void testFunctionAndHex() throws Exception {
        String style = "color:rgb(200,100,50)";
        CssParser parser = new CssParser((Reader)new StringReader(style));
        parser.parse();
        HashMap result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("color"), (Object)"rgb(200,100,50)");
        parser.ReInit((Reader)new StringReader("color:#ffeedd"));
        parser.parse();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("color"), (Object)"#ffeedd");
    }

    public void testBorderWidth() throws Exception {
        String style = "border-width: medium thin";
        CssParser parser = new CssParser((Reader)new StringReader(style));
        parser.parse();
        HashMap result = parser.getCssProperties();
        CssParserTest.assertEquals(result.get("border-top-width"), (Object)"medium");
        CssParserTest.assertEquals(result.get("border-right-width"), (Object)"thin");
        CssParserTest.assertEquals(result.get("border-bottom-width"), (Object)"medium");
        CssParserTest.assertEquals(result.get("border-left-width"), (Object)"thin");
    }

    public void testwithException1() throws Exception {
        String style = "border:1p red double";
        CssParser parser = new CssParser((Reader)new StringReader(style));
        parser.parse();
        HashMap result = parser.getCssProperties();
        CssParserTest.assertTrue((boolean)result.isEmpty());
    }

    public void testwithException() throws Exception {
        String style = "border:1p red double;display:inline;";
        CssParser parser = new CssParser((Reader)new StringReader(style));
        parser.parse();
        HashMap result = parser.getCssProperties();
        CssParserTest.assertEquals((int)1, (int)result.size());
        CssParserTest.assertEquals((Object)"inline", result.get("display"));
    }
}

