/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.ir.EngineIRReader;
import org.eclipse.birt.report.engine.ir.EngineIRWriter;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.ReportDesignWriter;
import org.eclipse.birt.report.engine.parser.ReportParser;

public class EngineIRIOTest
extends EngineCase {
    public void testIO() throws Exception {
        String[] designStreams = new String[]{"../parser/report_item_test.rptdesign", "../parser/text_test.rptdesign", "../parser/toc_test.rptdesign", "../parser/user_property_test.rptdesign", "../parser/visibility_test.rptdesign"};
        int i = 0;
        while (i < designStreams.length) {
            this.doTestIO(designStreams[i]);
            ++i;
        }
    }

    public void doTestIO(String designName) throws Exception {
        Report report = new ReportParser().parse(".", ((Object)((Object)this)).getClass().getResourceAsStream(designName));
        EngineIRIOTest.assertTrue((report != null ? 1 : 0) != 0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new EngineIRWriter().write((OutputStream)out, report);
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        EngineIRReader reader = new EngineIRReader();
        Report report2 = reader.read((InputStream)in);
        reader.link(report2, report.getReportDesign());
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        ReportDesignWriter writer = new ReportDesignWriter();
        writer.write((OutputStream)out1, report);
        writer.write((OutputStream)out2, report2);
        String golden = new String(out1.toByteArray());
        String value = new String(out2.toByteArray());
        EngineIRIOTest.assertEquals((String)golden, (String)value);
    }
}

