/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.layout.emitter.util.BackgroundImageLayout;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;

public class BackgroundImageLayoutTest
extends TestCase {
    public void testNoRepeatOfSmallImage() {
        Position imagePosition = new Position(2.0f, 2.0f);
        BackgroundImageLayout layout = this.getLayoutOfSmallImage();
        List positions = layout.getImagePositions(10);
        BackgroundImageLayoutTest.assertEquals((int)1, (int)positions.size());
        BackgroundImageLayoutTest.assertEquals((Object)imagePosition, positions.iterator().next());
    }

    public void testNoRepeatOfSmallImage2() {
        Position imagePosition = new Position(2.0f, 2.0f);
        BackgroundImageLayout layout = this.getLayoutOfSmallImage2();
        List positions = layout.getImagePositions(10);
        BackgroundImageLayoutTest.assertEquals((int)1, (int)positions.size());
        BackgroundImageLayoutTest.assertEquals((Object)imagePosition, positions.iterator().next());
    }

    public void testRepeatXOfSmallImage() {
        ArrayList<Position> expected = new ArrayList<Position>();
        float x = -1.0f;
        while (x <= 8.0f) {
            expected.add(new Position(x, 2.0f));
            x = (float)((double)x + 3.0);
        }
        BackgroundImageLayout layout = this.getLayoutOfSmallImage();
        List actual = layout.getImagePositions(11);
        BackgroundImageLayoutTest.assertEquals(expected, (Object)actual);
    }

    public void testRepeatYOfSmallImage() {
        ArrayList<Position> expected = new ArrayList<Position>();
        float y = -1.0f;
        while (y <= 8.0f) {
            expected.add(new Position(2.0f, y));
            y = (float)((double)y + 3.0);
        }
        BackgroundImageLayout layout = this.getLayoutOfSmallImage();
        List actual = layout.getImagePositions(12);
        BackgroundImageLayoutTest.assertEquals(expected, (Object)actual);
    }

    public void testRepeatOfSmallImage() {
        ArrayList<Position> expected = new ArrayList<Position>();
        float y = -1.0f;
        while (y <= 8.0f) {
            float x = -1.0f;
            while (x <= 8.0f) {
                expected.add(new Position(x, y));
                x = (float)((double)x + 3.0);
            }
            y = (float)((double)y + 3.0);
        }
        Collections.sort(expected);
        BackgroundImageLayout layout = this.getLayoutOfSmallImage();
        List actual = layout.getImagePositions(13);
        BackgroundImageLayoutTest.assertEquals(expected, (Object)actual);
    }

    public void testNoRepeatOfBigImage() {
        Position areaPosition = new Position(0.0f, 0.0f);
        Position areaSize = new Position(10.0f, 10.0f);
        Position imagePosition = new Position(-1.0f, -1.0f);
        Position imageSize = new Position(11.0f, 11.0f);
        BackgroundImageLayout layout = new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
        List positions = layout.getImagePositions(10);
        BackgroundImageLayoutTest.assertEquals((int)1, (int)positions.size());
        BackgroundImageLayoutTest.assertEquals((Object)imagePosition, positions.iterator().next());
        positions = layout.getImagePositions(11);
        BackgroundImageLayoutTest.assertEquals((int)1, (int)positions.size());
        BackgroundImageLayoutTest.assertEquals((Object)imagePosition, positions.iterator().next());
        positions = layout.getImagePositions(12);
        BackgroundImageLayoutTest.assertEquals((int)1, (int)positions.size());
        BackgroundImageLayoutTest.assertEquals((Object)imagePosition, positions.iterator().next());
        positions = layout.getImagePositions(13);
        BackgroundImageLayoutTest.assertEquals((int)1, (int)positions.size());
        BackgroundImageLayoutTest.assertEquals((Object)imagePosition, positions.iterator().next());
    }

    private BackgroundImageLayout getLayoutOfSmallImage() {
        Position areaPosition = new Position(0.0f, 0.0f);
        Position areaSize = new Position(10.0f, 10.0f);
        Position imagePosition = new Position(2.0f, 2.0f);
        Position imageSize = new Position(3.0f, 3.0f);
        return new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
    }

    private BackgroundImageLayout getLayoutOfSmallImage2() {
        Position areaPosition = new Position(2.0f, 2.0f);
        Position areaSize = new Position(10.0f, 10.0f);
        Position imagePosition = new Position(2.0f, 2.0f);
        Position imageSize = new Position(3.0f, 3.0f);
        return new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
    }
}

