/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.List;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.TOCNode;

public class HTMLLayoutTest
extends EngineCase {
    public void testPageBreak() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/html/HTMLLayoutTest_1.xml";
        IReportDocument document = this.createReportDocument(designFile);
        HTMLLayoutTest.assertEquals((long)1L, (long)this.getPageNumber(document, "Australia"));
        HTMLLayoutTest.assertEquals((long)1L, (long)this.getPageNumber(document, "France"));
        HTMLLayoutTest.assertEquals((long)2L, (long)this.getPageNumber(document, "Japan"));
        HTMLLayoutTest.assertEquals((long)2L, (long)this.getPageNumber(document, "UK"));
        HTMLLayoutTest.assertEquals((long)3L, (long)this.getPageNumber(document, "USA"));
    }

    public void testPageBreak2() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/html/HTMLLayoutTest_2.xml";
        IReportDocument document = this.createReportDocument(designFile);
        this.checkBookmark(document, "Australia", 2L);
        this.checkBookmark(document, "France", 3L);
        this.checkBookmark(document, "Japan", 4L);
        this.checkBookmark(document, "UK", 5L);
        this.checkBookmark(document, "USA", 6L);
    }

    private void checkBookmark(IReportDocument document, String bookmark, long pageNumber) {
        List tocs = document.findTOCByName(bookmark);
        HTMLLayoutTest.assertEquals((int)2, (int)tocs.size());
        TOCNode toc0 = (TOCNode)tocs.get(0);
        TOCNode toc1 = (TOCNode)tocs.get(1);
        long pageNumber0 = document.getPageNumber(toc0.getNodeID());
        long pageNumber1 = document.getPageNumber(toc1.getNodeID());
        HTMLLayoutTest.assertEquals((long)pageNumber, (long)pageNumber0);
        HTMLLayoutTest.assertEquals((long)pageNumber, (long)pageNumber1);
    }

    private long getPageNumber(IReportDocument document, String bookmark) {
        List tocs = document.findTOCByName(bookmark);
        TOCNode toc = (TOCNode)tocs.get(0);
        return document.getPageNumber(toc.getBookmark());
    }
}

