/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.layout.pdf.IEmitterMonitor;
import org.eclipse.birt.report.engine.layout.pdf.TestRunAndRenderTask;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LineArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;

public abstract class PDFLayoutTest
extends EngineCase {
    protected boolean isEmpty(ContainerArea container) {
        int childrenCount = container.getChildrenCount();
        if (childrenCount == 0) {
            return true;
        }
        Iterator iter = container.getChildren();
        if (iter.hasNext()) {
            Object children = iter.next();
            if (children instanceof ContainerArea) {
                return this.isEmpty((ContainerArea)children);
            }
            return false;
        }
        return true;
    }

    protected IArea getChildren(ContainerArea container, int index) {
        int current = 0;
        Iterator children = container.getChildren();
        while (children.hasNext()) {
            Object child = children.next();
            if (current == index) {
                return (IArea)child;
            }
            ++current;
        }
        return null;
    }

    protected String getText(LineArea line, int index) {
        InlineContainerArea inlineArea = (InlineContainerArea)this.getChildren((ContainerArea)line, index);
        IArea area = this.getChildren((ContainerArea)inlineArea, 0);
        if (!(area instanceof TextArea)) {
            PDFLayoutTest.fail((String)("Child " + index + " of line doesn't contains text Area"));
        }
        return ((TextArea)area).getText();
    }

    protected List getPageAreas(String designFile) throws EngineException {
        IReportRunnable report = this.openReportDesign(designFile);
        return this.getPageAreas(report);
    }

    protected IReportRunnable openReportDesign(String designFile) throws EngineException {
        this.useDesignFile(designFile);
        IReportRunnable report = this.engine.openReportDesign("design.rptdesign");
        return report;
    }

    protected List getPageAreas(IReportRunnable runnable) throws EngineException {
        ArrayList pageAreas = new ArrayList();
        PageMonitor monitor = new PageMonitor(pageAreas);
        TestRunAndRenderTask runAndRenderTask = new TestRunAndRenderTask(this.engine, runnable, monitor);
        runAndRenderTask.setRenderOption((IRenderOption)this.createRenderOption());
        runAndRenderTask.run();
        runAndRenderTask.close();
        return pageAreas;
    }

    protected List getpageAreas(String designFile) throws EngineException {
        IReportRunnable report = this.openReportDesign(designFile);
        List pageAreas = this.getPageAreas(report);
        return pageAreas;
    }

    protected PDFRenderOption createRenderOption() {
        PDFRenderOption options = new PDFRenderOption();
        options.setOutputFormat("pdf");
        options.setOutputStream((OutputStream)new ByteArrayOutputStream());
        return options;
    }

    protected static class PageMonitor
    implements IEmitterMonitor {
        List pageAreas;

        public PageMonitor(List pageAreas) {
            this.pageAreas = pageAreas;
        }

        public void onMethod(Method method, Object[] args) {
            if ("startPage".equals(method.getName())) {
                PageContent pageContent = (PageContent)args[0];
                this.pageAreas.add(pageContent.getExtension(1));
            }
        }
    }
}

