/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutTest;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;

public class PDFTableLMTest
extends PDFLayoutTest {
    public void testFixedTableLayout() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/tableFixedLayout.xml";
        List pageAreas = this.getpageAreas(designFile);
        PDFTableLMTest.assertEquals((int)1, (int)pageAreas.size());
        PageArea pageArea = (PageArea)pageAreas.get(0);
        ContainerArea body = (ContainerArea)pageArea.getBody();
        PDFTableLMTest.assertTrue((body.getChildrenCount() == 11 ? 1 : 0) != 0);
        Iterator iter = body.getChildren();
        TableArea table = (TableArea)iter.next();
        int[] nArray = new int[3];
        nArray[0] = 144;
        nArray[1] = 288;
        this.validateColumnWidth(table, nArray);
        table = (TableArea)iter.next();
        this.validateColumnWidth(table, new int[]{144, 108, 180});
        table = (TableArea)iter.next();
        this.validateColumnWidth(table, new int[]{144, 177, 111});
        table = (TableArea)iter.next();
        this.validateColumnWidth(table, new int[]{144, 72, 216});
        table = (TableArea)iter.next();
        this.validateColumnWidth(table, new int[]{108, 108, 216});
        table = (TableArea)iter.next();
        this.validateColumnWidth(table, new int[]{144, 208, 80});
        table = (TableArea)iter.next();
        int[] nArray2 = new int[3];
        nArray2[1] = 432;
        this.validateColumnWidth(table, nArray2);
        table = (TableArea)iter.next();
        int[] nArray3 = new int[3];
        nArray3[0] = 216;
        nArray3[1] = 432;
        this.validateColumnWidth(table, nArray3);
        table = (TableArea)iter.next();
        int[] nArray4 = new int[3];
        nArray4[0] = 216;
        nArray4[1] = 432;
        this.validateColumnWidth(table, nArray4);
        table = (TableArea)iter.next();
        this.validateColumnWidth(table, new int[]{216, 216});
        table = (TableArea)iter.next();
        this.validateColumnWidth(table, new int[]{50, 10, 40});
    }

    public void testBorder() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/176794.xml";
        List pageAreas = this.getpageAreas(designFile);
        PageArea page = (PageArea)pageAreas.get(0);
        Iterator children = page.getBody().getChildren();
        TableArea table1 = (TableArea)children.next();
        TableArea table2 = (TableArea)children.next();
        PDFTableLMTest.assertEquals((int)17847, (int)table1.getHeight());
        PDFTableLMTest.assertEquals((int)17847, (int)table2.getY());
    }

    private void validateColumnWidth(TableArea table, int[] cols) {
        PDFTableLMTest.assertTrue((table != null ? 1 : 0) != 0);
        PDFTableLMTest.assertTrue((table.getChildrenCount() > 0 ? 1 : 0) != 0);
        RowArea row = (RowArea)table.getChildren().next();
        Iterator iter = row.getChildren();
        int i = 0;
        while (i < cols.length) {
            CellArea cell = (CellArea)iter.next();
            PDFTableLMTest.assertEquals((Object)new Integer(cols[i]), (Object)new Integer((cell.getWidth() + 499) / 1000));
            ++i;
        }
    }
}

