/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.core.framework.parser.AbstractParseState;
import org.eclipse.birt.core.framework.parser.XMLParserException;
import org.eclipse.birt.core.framework.parser.XMLParserHandler;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLContentReader {
    public static IReportContent read(InputStream in) {
        try {
            IReportContent reportContent = ContentFactory.createReportContent(null);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            if (in != null) {
                parser.parse(in, (DefaultHandler)((Object)new XMLContentParser(reportContent)));
                in.close();
                return reportContent;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    static class XMLContentParser
    extends XMLParserHandler {
        IReportContent reportContent = null;

        public XMLContentParser(IReportContent content) {
            this.reportContent = content;
        }

        protected String getAttrValue(Attributes attr, String name) {
            String value = attr.getValue(name);
            if (value != null && "".equals(value = value.trim())) {
                return null;
            }
            return value;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.currentElement = qName;
            AbstractParseState newState = this.topState().startElement(qName);
            newState.parseAttrs(atts);
            AbstractParseState jumpToState = newState.jumpTo();
            if (jumpToState != null) {
                this.pushState(jumpToState);
                return;
            }
            newState.setElementName(this.currentElement);
            this.pushState(newState);
        }

        public AbstractParseState createStartState() {
            return new ReportContentState(this.reportContent);
        }

        public void semanticError(XMLParserException ex) {
        }

        protected int getIntAttribute(Attributes attrs, String name, int defaultValue) {
            String value = attrs.getValue(name);
            if (value == null) {
                try {
                    int intValue = Integer.parseInt(value);
                    return intValue;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            return defaultValue;
        }

        protected boolean getBooleanAttribute(Attributes attrs, String name) {
            String value = attrs.getValue(name);
            return Boolean.valueOf(value);
        }

        class ContainerContentState
        extends ContentParseState {
            ContainerContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createContainerContent());
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("text")) {
                    return new TextContentState();
                }
                if (tagName.equalsIgnoreCase("label")) {
                    return new LabelContentState();
                }
                if (tagName.equalsIgnoreCase("data")) {
                    return new DataContentState();
                }
                if (tagName.equalsIgnoreCase("image")) {
                    return new ImageContentState();
                }
                if (tagName.equalsIgnoreCase("foreign")) {
                    return new ForeignContentState();
                }
                if (tagName.equalsIgnoreCase("container")) {
                    return new ContainerContentState();
                }
                if (tagName.equalsIgnoreCase("table")) {
                    return new TableContentState();
                }
                return super.startElement(tagName);
            }
        }

        class ContentParseState
        extends XMLParserHandler.InnerParseState {
            IContent content;

            ContentParseState() {
                super((XMLParserHandler)XMLContentParser.this);
            }

            public void setContent(IContent content) {
                this.content = content;
            }

            public IContent getContent() {
                return this.content;
            }

            public void parseAttrs(Attributes attrs) throws XMLParserException {
                String style = attrs.getValue("style");
                if (style != null) {
                    IStyle inlineStyle = XMLContentParser.this.reportContent.createStyle();
                    inlineStyle.setCssText(style);
                    this.content.setInlineStyle(inlineStyle);
                }
            }

            public void endElement(AbstractParseState state) {
                ContentParseState contentState = (ContentParseState)state;
                IContent child = contentState.content;
                this.content.getChildren().add(child);
                child.setParent((IElement)this.content);
            }
        }

        class DataContentState
        extends ContentParseState {
            DataContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createDataContent());
            }
        }

        class ForeignContentState
        extends ContentParseState {
            ForeignContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createForeignContent());
            }
        }

        class ImageContentState
        extends ContentParseState {
            ImageContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createImageContent());
            }
        }

        class LabelContentState
        extends ContentParseState {
            LabelContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createLabelContent());
            }
        }

        class PageBodyState
        extends XMLParserHandler.InnerParseState {
            IPageContent pageContent;

            PageBodyState(IPageContent pageContent) {
                super((XMLParserHandler)XMLContentParser.this);
                this.pageContent = pageContent;
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("text")) {
                    return new TextContentState();
                }
                if (tagName.equalsIgnoreCase("label")) {
                    return new LabelContentState();
                }
                if (tagName.equalsIgnoreCase("data")) {
                    return new DataContentState();
                }
                if (tagName.equalsIgnoreCase("image")) {
                    return new ImageContentState();
                }
                if (tagName.equalsIgnoreCase("foreign")) {
                    return new ForeignContentState();
                }
                if (tagName.equalsIgnoreCase("container")) {
                    return new ContainerContentState();
                }
                if (tagName.equalsIgnoreCase("table")) {
                    return new TableContentState();
                }
                return super.startElement(tagName);
            }

            public void endElement(AbstractParseState state) {
                ContentParseState contentState = (ContentParseState)state;
                this.pageContent.getChildren().add(contentState.content);
            }
        }

        class PageContentState
        extends ContentParseState {
            PageContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createPageContent());
            }

            public AbstractParseState startElement(String tagName) {
                IPageContent pageContent = (IPageContent)this.content;
                if (tagName.equalsIgnoreCase("page-header")) {
                    return new PageHeaderState(pageContent);
                }
                if (tagName.equalsIgnoreCase("page-footer")) {
                    return new PageFooterState(pageContent);
                }
                if (tagName.equalsIgnoreCase("page-body")) {
                    return new PageBodyState(pageContent);
                }
                return super.startElement(tagName);
            }
        }

        class PageFooterState
        extends XMLParserHandler.InnerParseState {
            IPageContent pageContent;

            PageFooterState(IPageContent pageContent) {
                super((XMLParserHandler)XMLContentParser.this);
                this.pageContent = pageContent;
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("text")) {
                    return new TextContentState();
                }
                if (tagName.equalsIgnoreCase("label")) {
                    return new LabelContentState();
                }
                if (tagName.equalsIgnoreCase("data")) {
                    return new DataContentState();
                }
                if (tagName.equalsIgnoreCase("image")) {
                    return new ImageContentState();
                }
                if (tagName.equalsIgnoreCase("foreign")) {
                    return new ForeignContentState();
                }
                if (tagName.equalsIgnoreCase("container")) {
                    return new ContainerContentState();
                }
                if (tagName.equalsIgnoreCase("table")) {
                    return new TableContentState();
                }
                return super.startElement(tagName);
            }

            public void endElement(AbstractParseState state) {
                ContentParseState contentState = (ContentParseState)state;
                this.pageContent.getFooter().add(contentState.content);
            }
        }

        class PageHeaderState
        extends XMLParserHandler.InnerParseState {
            IPageContent pageContent;

            PageHeaderState(IPageContent pageContent) {
                super((XMLParserHandler)XMLContentParser.this);
                this.pageContent = pageContent;
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("text")) {
                    return new TextContentState();
                }
                if (tagName.equalsIgnoreCase("label")) {
                    return new LabelContentState();
                }
                if (tagName.equalsIgnoreCase("data")) {
                    return new DataContentState();
                }
                if (tagName.equalsIgnoreCase("image")) {
                    return new ImageContentState();
                }
                if (tagName.equalsIgnoreCase("foreign")) {
                    return new ForeignContentState();
                }
                if (tagName.equalsIgnoreCase("container")) {
                    return new ContainerContentState();
                }
                if (tagName.equalsIgnoreCase("table")) {
                    return new TableContentState();
                }
                return super.startElement(tagName);
            }

            public void endElement(AbstractParseState state) {
                ContentParseState contentState = (ContentParseState)state;
                this.pageContent.getHeader().add(contentState.content);
            }
        }

        class ReportContentState
        extends XMLParserHandler.InnerParseState {
            IReportContent reportContent;

            ReportContentState(IReportContent reportContent) {
                super((XMLParserHandler)XMLContentParser.this);
                this.reportContent = reportContent;
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("text")) {
                    return new TextContentState();
                }
                if (tagName.equalsIgnoreCase("label")) {
                    return new LabelContentState();
                }
                if (tagName.equalsIgnoreCase("data")) {
                    return new DataContentState();
                }
                if (tagName.equalsIgnoreCase("image")) {
                    return new ImageContentState();
                }
                if (tagName.equalsIgnoreCase("foreign")) {
                    return new ForeignContentState();
                }
                if (tagName.equalsIgnoreCase("container")) {
                    return new ContainerContentState();
                }
                if (tagName.equalsIgnoreCase("table")) {
                    return new TableContentState();
                }
                if (tagName.equalsIgnoreCase("page")) {
                    return new PageContentState();
                }
                return super.startElement(tagName);
            }
        }

        class TableBandContentState
        extends ContentParseState {
            ITableBandContent bandContent;

            TableBandContentState(int bandType) {
                this.bandContent = XMLContentParser.this.reportContent.createTableBandContent();
                this.bandContent.setBandType(bandType);
                this.setContent((IContent)this.bandContent);
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("table-row")) {
                    return new TableRowContentState();
                }
                return super.startElement(tagName);
            }
        }

        class TableCellContentState
        extends ContentParseState {
            TableCellContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createCellContent());
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("text")) {
                    return new TextContentState();
                }
                if (tagName.equalsIgnoreCase("label")) {
                    return new LabelContentState();
                }
                if (tagName.equalsIgnoreCase("data")) {
                    return new DataContentState();
                }
                if (tagName.equalsIgnoreCase("image")) {
                    return new ImageContentState();
                }
                if (tagName.equalsIgnoreCase("foreign")) {
                    return new ForeignContentState();
                }
                if (tagName.equalsIgnoreCase("container")) {
                    return new ContainerContentState();
                }
                if (tagName.equalsIgnoreCase("table")) {
                    return new TableContentState();
                }
                return super.startElement(tagName);
            }

            public void parseAttrs(Attributes attrs) throws XMLParserException {
                ICellContent cellContent = (ICellContent)this.content;
                cellContent.setColSpan(XMLContentParser.this.getIntAttribute(attrs, "col-span", 1));
                cellContent.setRowSpan(XMLContentParser.this.getIntAttribute(attrs, "row-span", 1));
                cellContent.setColumn(XMLContentParser.this.getIntAttribute(attrs, "cell", -1));
                super.parseAttrs(attrs);
            }
        }

        class TableContentState
        extends ContentParseState {
            TableContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createTableContent());
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("table-header")) {
                    return new TableBandContentState(1);
                }
                if (tagName.equalsIgnoreCase("table-body")) {
                    return new TableBandContentState(0);
                }
                if (tagName.equalsIgnoreCase("table-footer")) {
                    return new TableBandContentState(2);
                }
                return super.startElement(tagName);
            }

            public void parseAttrs(Attributes attrs) throws XMLParserException {
                ITableContent tableContent = (ITableContent)this.content;
                int columnCount = XMLContentParser.this.getIntAttribute(attrs, "column", 1);
                int i = 0;
                while (i < columnCount) {
                    tableContent.addColumn((IColumn)new Column(XMLContentParser.this.reportContent));
                    ++i;
                }
                super.parseAttrs(attrs);
            }
        }

        class TableRowContentState
        extends ContentParseState {
            TableRowContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createRowContent());
            }

            public AbstractParseState startElement(String tagName) {
                if (tagName.equalsIgnoreCase("cell")) {
                    return new TableCellContentState();
                }
                return super.startElement(tagName);
            }

            public void parseAttrs(Attributes attrs) throws XMLParserException {
                IRowContent rowContent = (IRowContent)this.content;
                rowContent.setRowID(XMLContentParser.this.getIntAttribute(attrs, "row", -1));
                super.parseAttrs(attrs);
            }
        }

        class TextContentState
        extends ContentParseState {
            TextContentState() {
                this.setContent((IContent)XMLContentParser.this.reportContent.createTextContent());
            }
        }
    }
}

