/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.TOCTestCase;

public class TOCBuilderTest
extends TOCTestCase {
    static final String GOLDEN_TOC_TEST_1 = "<entry nodeId=\"/\">    <entry nodeId=\"__TOC_0\" tocValue=\"report-header\"/>    <group nodeId=\"__TOC_1\">        <entry nodeId=\"__TOC_1_0\" hiddenFormats=\"html\">            <entry nodeId=\"__TOC_1_0_0\" tocValue=\"detail1\"/>            <entry nodeId=\"__TOC_1_0_1\" tocValue=\"detail2\"/>        </entry>    </group></entry>";
    static final String GOLDEN_TOC_TEST_2 = "<entry nodeId=\"/\">    <entry nodeId=\"__TOC_0\" tocValue=\"report-header\"/>    <group nodeId=\"__TOC_1\" tocValue=\"html\">        <entry nodeId=\"__TOC_1_0\" tocValue=\"detail1\"/>        <entry nodeId=\"__TOC_1_1\" tocValue=\"detail2\"/>    </group></entry>";
    static final String GOLDEN_TOC_TEST_3 = "<entry nodeId=\"/\">    <entry nodeId=\"__TOC_0\" tocValue=\"report-header\"/>    <group nodeId=\"__TOC_1\" hiddenFormats=\"pdf\">        <entry nodeId=\"__TOC_1_0\" hiddenFormats=\"html\">            <entry nodeId=\"__TOC_1_0_0\" tocValue=\"detail1\" hiddenFormats=\"html\"/>            <entry nodeId=\"__TOC_1_0_1\" tocValue=\"detail2\"/>        </entry>    </group></entry>";
    static final String GOLDEN_TOC_TEST_4 = "<entry nodeId=\"/\">    <entry nodeId=\"__TOC_0\" tocValue=\"report-header\"/>    <group nodeId=\"__TOC_1\">        <entry nodeId=\"__TOC_1_0\" hiddenFormats=\"html\">            <entry nodeId=\"__TOC_1_0_1\" hiddenFormats=\"pdf\">                <entry nodeId=\"__TOC_1_0_1_0\" tocValue=\"label\"/>            </entry>        </entry>    </group></entry>";

    public void testHiddenFormat1() {
        TOCBuilder builder = new TOCBuilder();
        this.createTOCTest1(builder);
        String tocTree = this.toString(builder.getTOCTree());
        System.out.println(tocTree);
        TOCBuilderTest.assertEquals((String)GOLDEN_TOC_TEST_1.replaceAll("\\s", ""), (String)tocTree.replaceAll("\\s", ""));
    }

    void createTOCTest1(TOCBuilder builder) {
        TOCEntry reportHeader = builder.startEntry(null, (Object)"report-header", null, null, -1L);
        builder.closeEntry(reportHeader);
        TOCEntry group = builder.startGroupEntry(null, null, null, null, -1L);
        TOCEntry list = builder.startDummyEntry(group, "html");
        TOCEntry detail1 = builder.startEntry(list, (Object)"detail1", null, null, -1L);
        builder.closeEntry(detail1);
        TOCEntry detail2 = builder.startEntry(list, (Object)"detail2", null, null, -1L);
        builder.closeEntry(detail2);
        builder.closeEntry(list);
        builder.closeGroupEntry(group);
    }

    public void testHiddenFormat2() {
        TOCBuilder builder = new TOCBuilder();
        this.createTOCTest2(builder);
        String tocTree = this.toString(builder.getTOCTree());
        System.out.println(tocTree);
        TOCBuilderTest.assertEquals((String)GOLDEN_TOC_TEST_2.replaceAll("\\s", ""), (String)tocTree.replaceAll("\\s", ""));
    }

    protected void createTOCTest2(TOCBuilder builder) {
        TOCEntry reportHeader = builder.startEntry(null, (Object)"report-header", null, null, -1L);
        builder.closeEntry(reportHeader);
        TOCEntry group = builder.startGroupEntry(null, (Object)"html", null, null, -1L);
        TOCEntry detail1 = builder.startEntry(group, (Object)"detail1", null, null, -1L);
        builder.closeEntry(detail1);
        TOCEntry detail2 = builder.startEntry(group, (Object)"detail2", null, null, -1L);
        builder.closeEntry(detail2);
        builder.closeGroupEntry(group);
    }

    public void testHiddenFormat3() {
        TOCBuilder builder = new TOCBuilder();
        this.createTOCTest3(builder);
        String tocTree = this.toString(builder.getTOCTree());
        System.out.println(tocTree);
        TOCBuilderTest.assertEquals((String)GOLDEN_TOC_TEST_3.replaceAll("\\s", ""), (String)tocTree.replaceAll("\\s", ""));
    }

    protected void createTOCTest3(TOCBuilder builder) {
        TOCEntry reportHeader = builder.startEntry(null, (Object)"report-header", null, null, -1L);
        builder.closeEntry(reportHeader);
        TOCEntry group = builder.startGroupEntry(null, null, null, "pdf", -1L);
        TOCEntry list = builder.startDummyEntry(group, "html");
        TOCEntry detail1 = builder.startEntry(list, (Object)"detail1", null, "html", -1L);
        builder.closeEntry(detail1);
        TOCEntry detail2 = builder.startEntry(list, (Object)"detail2", null, null, -1L);
        builder.closeEntry(detail2);
        builder.closeEntry(list);
        builder.closeGroupEntry(group);
    }

    public void testHiddenFormat4() {
        TOCBuilder builder = new TOCBuilder();
        this.createTOCTest4(builder);
        String tocTree = this.toString(builder.getTOCTree());
        System.out.println(tocTree);
        TOCBuilderTest.assertEquals((String)GOLDEN_TOC_TEST_4.replaceAll("\\s", ""), (String)tocTree.replaceAll("\\s", ""));
    }

    protected void createTOCTest4(TOCBuilder builder) {
        TOCEntry reportHeader = builder.startEntry(null, (Object)"report-header", null, null, -1L);
        builder.closeEntry(reportHeader);
        TOCEntry group = builder.startGroupEntry(null, null, null, null, -1L);
        TOCEntry list = builder.startDummyEntry(group, "html");
        TOCEntry detail1 = builder.startDummyEntry(list, "html");
        TOCEntry label = builder.startDummyEntry(detail1, "html");
        builder.closeEntry(label);
        builder.closeEntry(detail1);
        TOCEntry detail2 = builder.startDummyEntry(list, "pdf");
        TOCEntry label2 = builder.startEntry(detail2, (Object)"label", null, -1L);
        builder.closeEntry(label2);
        builder.closeEntry(detail2);
        builder.closeEntry(list);
        builder.closeGroupEntry(group);
    }
}

