/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.IOException;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.report.engine.toc.ByteArrayRAInputStream;
import org.eclipse.birt.report.engine.toc.ByteArrayRAOutputStream;
import org.eclipse.birt.report.engine.toc.ITOCWriter;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.TOCReader;
import org.eclipse.birt.report.engine.toc.TOCTestCase;
import org.eclipse.birt.report.engine.toc.TOCWriter;

public class TOCReadWriteTest
extends TOCTestCase {
    static final String GOLDEN_TOC_TEST = "<entry nodeId=\"/\">    <entry nodeId=\"__TOC_0\" tocValue=\"report-header\"/>    <group nodeId=\"__TOC_1\">        <entry nodeId=\"__TOC_1_0\" hiddenFormats=\"html\">            <entry nodeId=\"__TOC_1_0_1\" hiddenFormats=\"pdf\">                <entry nodeId=\"__TOC_1_0_1_0\" tocValue=\"label\"/>            </entry>        </entry>    </group></entry>";

    public void testHiddenFormat4() throws IOException {
        ByteArrayRAOutputStream out = new ByteArrayRAOutputStream();
        TOCWriter writer = new TOCWriter((RAOutputStream)out);
        TOCBuilder builder = new TOCBuilder((ITOCWriter)writer);
        this.createTOCTest(builder);
        writer.close();
        out.close();
        ByteArrayRAInputStream in = new ByteArrayRAInputStream(out.toByteArray());
        TOCReader reader = new TOCReader((RAInputStream)in, ((Object)((Object)this)).getClass().getClassLoader());
        ITreeNode treeNode = reader.readTree();
        String tocTree = this.toString(treeNode);
        reader.close();
        in.close();
        System.out.println(tocTree);
        TOCReadWriteTest.assertEquals((String)GOLDEN_TOC_TEST.replaceAll("\\s", ""), (String)tocTree.replaceAll("\\s", ""));
    }

    protected void createTOCTest(TOCBuilder builder) {
        this.createEntry(builder, null, "report-header");
        TOCEntry group = this.startGroupEntry(builder, null, null);
        TOCEntry list = this.startDummyEntry(builder, group, "html");
        TOCEntry detail1 = this.startDummyEntry(builder, list, "pdf");
        TOCEntry label = this.startDummyEntry(builder, detail1, "html");
        builder.closeEntry(label);
        builder.closeEntry(detail1);
        TOCEntry detail2 = builder.startDummyEntry(list, "pdf");
        this.createEntry(builder, detail2, "label");
        builder.closeEntry(detail2);
        builder.closeEntry(list);
        builder.closeGroupEntry(group);
    }
}

