/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.toc.TOCTestCase;

public class TOCTest
extends TOCTestCase {
    static final String TOC_TEST_TOC = "org/eclipse/birt/report/engine/toc/TOCNodeTest.xml";
    static final String TOC_TEST_TOC_1 = "org/eclipse/birt/report/engine/toc/TOCNodeTest1.xml";
    static final String TOC_TEST_TOC_2 = "org/eclipse/birt/report/engine/toc/TOCNodeTest2.xml";
    static final String TOC_TEST_TOC_3 = "org/eclipse/birt/report/engine/toc/TOCNodeTest3.xml";
    static final String TOC_TEST_TOC_4 = "org/eclipse/birt/report/engine/toc/TOCNodeTest4.xml";
    static final String TOC_TEST_GOLDEN = "<toc nodeId=\"/\"/>";
    static final String TOC_TEST_1_GOLDEN = "<toc nodeId=\"/\">    <toc nodeId=\"__TOC_0\" displayText=\"leaf1\"/>    <toc nodeId=\"__TOC_1\" displayText=\"leaf2\"/></toc>";
    static final String TOC_TEST_2_GOLDEN = "<toc nodeId=\"/\">    <toc nodeId=\"__TOC_0\" displayText=\"leaf2\">        <toc nodeId=\"__TOC_0_1\" displayText=\"leaf2\"/>        <toc nodeId=\"__TOC_0_2\" displayText=\"leaf3\"/>    </toc></toc>";
    static final String TOC_TEST_3_GOLDEN = "<toc nodeId=\"/\"/>";
    static final String TOC_TEST_4_GOLDEN = "<toc nodeId=\"/\">    <toc nodeId=\"__TOC_0\" displayText=\"leaf3\">        <toc nodeId=\"__TOC_0_1\" displayText=\"leaf3\"/>        <toc nodeId=\"__TOC_0_2\" displayText=\"leaf4\"/>    </toc></toc>";

    public void testTOC() throws Exception {
        this.doTest(TOC_TEST_TOC, "<toc nodeId=\"/\"/>");
    }

    protected void doTest(String design, String golden) throws Exception {
        this.copyResource(design, "utest/toc.rptdesign");
        this.createReportDocument("utest/toc.rptdesign", "utest/toc.rptdocument");
        IReportDocument document = this.engine.openReportDocument("utest/toc.rptdocument");
        try {
            ITOCTree tree = document.getTOCTree("html", ULocale.ENGLISH);
            String out = this.toString(tree.getRoot());
            TOCTest.assertEquals((String)golden.replaceAll("\\s", ""), (String)out.replaceAll("\\s", ""));
        }
        finally {
            document.close();
        }
    }
}

