/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_131308
extends ChartTestCase {
    private static String GOLDEN = "Regression_131308.jpg";
    private static String OUTPUT = "Regression_131308.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_131308();
    }

    public Regression_131308() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_131308.createAreaChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void test_regression_131308() throws Exception {
        Regression_131308 st = new Regression_131308();
        Regression_131308.assertTrue((boolean)st.compareBytes(GOLDEN, OUTPUT));
    }

    public static final Chart createAreaChart() {
        ChartWithAxes cwaArea = ChartWithAxesImpl.create();
        cwaArea.setType("Area Chart");
        cwaArea.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaArea.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaArea).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        xAxisPrimary.getLabel().getCaption().getFont().setRotation(75.0);
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaArea).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards", "Telephones", "Mouse", "NetCards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56, 0.0, 88.9, 93.25});
        NumberDataSet dsNumericValues2 = NumberDataSetImpl.create((Object)new double[]{143.26, 0.0, 95.25, 47.56, 35.8, 0.0, 123.45});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        AreaSeries as1 = (AreaSeries)AreaSeriesImpl.create();
        as1.setSeriesIdentifier((Object)"Actuate");
        as1.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN());
        as1.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        as1.getLabel().setVisible(true);
        as1.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)207, (int)41, (int)207), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        as1.setDataSet((DataSet)dsNumericValues2);
        as1.setStacked(true);
        SeriesDefinition sdY1 = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY1);
        sdY1.getSeriesPalette().update((Fill)ColorDefinitionImpl.GREEN());
        sdY1.getSeries().add((Object)as1);
        AreaSeries as2 = (AreaSeries)AreaSeriesImpl.create();
        as2.setSeriesIdentifier((Object)"Microsoft");
        as2.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        as2.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        as2.getLabel().setVisible(true);
        as2.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)207, (int)41, (int)207), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        as2.setDataSet((DataSet)dsNumericValues1);
        as2.setStacked(true);
        SeriesDefinition sdY2 = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY2);
        sdY2.getSeriesPalette().update((Fill)ColorDefinitionImpl.RED());
        sdY2.getSeries().add((Object)as2);
        return cwaArea;
    }
}

