/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_134885
extends ChartTestCase {
    private static String GOLDEN = "Regression_134885.jpg";
    private static String OUTPUT = "Regression_134885.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_134885();
    }

    public Regression_134885() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_134885.createPieChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void test_regression_134885() throws Exception {
        Regression_134885 st = new Regression_134885();
        Regression_134885.assertTrue((boolean)st.compareBytes(GOLDEN, OUTPUT));
    }

    public static final Chart createPieChart() {
        ChartWithoutAxes cwoaPie = ChartWithoutAxesImpl.create();
        cwoaPie.setType("Pie Chart");
        cwoaPie.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 0.0, 95.25, 47.56});
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)dsStringValue);
        SeriesDefinition series = SeriesDefinitionImpl.create();
        series.getSeries().add((Object)seCategory);
        cwoaPie.getSeriesDefinitions().add((Object)series);
        PieSeries ps = (PieSeries)PieSeriesImpl.create();
        ps.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        ps.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        ps.getLabel().setVisible(true);
        ps.setSeriesIdentifier((Object)"Actuate");
        ps.setDataSet((DataSet)dsNumericValues1);
        ps.setLeaderLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)239, (int)33, (int)3), (LineStyle)LineStyle.DASH_DOTTED_LITERAL, (int)3));
        ps.setLeaderLineStyle(LeaderLineStyle.FIXED_LENGTH_LITERAL);
        ps.setExplosion(0);
        ps.setSliceOutline(ColorDefinitionImpl.BLACK());
        SeriesDefinition seGroup1 = SeriesDefinitionImpl.create();
        series.getSeriesPalette().update(-2);
        series.getSeriesDefinitions().add((Object)seGroup1);
        seGroup1.getSeries().add((Object)ps);
        return cwoaPie;
    }
}

