/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import com.ibm.icu.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class Regression_139334_swt
extends Composite
implements PaintListener,
IUpdateNotifier,
SelectionListener {
    private IDeviceRenderer idr = null;
    private Chart cm = null;
    private static Combo cbType = null;
    private static Button btn = null;
    private GeneratedChartState gcs = null;
    private boolean bNeedsGeneration = true;
    private Map contextMap = new HashMap();

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setSize(600, 400);
        shell.setLayout((Layout)new GridLayout());
        Regression_139334_swt siv = new Regression_139334_swt((Composite)shell, 262144);
        siv.setLayoutData(new GridData(1808));
        siv.addPaintListener(siv);
        Composite cBottom = new Composite((Composite)shell, 0);
        cBottom.setLayoutData((Object)new GridData(768));
        cBottom.setLayout((Layout)new RowLayout());
        Label la = new Label(cBottom, 0);
        la.setText("Choose: ");
        cbType = new Combo(cBottom, 12);
        cbType.add("Bar Chart");
        cbType.select(0);
        btn = new Button(cBottom, 0);
        btn.setText("Update");
        btn.addSelectionListener((SelectionListener)siv);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    Regression_139334_swt(Composite parent, int style) {
        super(parent, style);
        PluginSettings ps = PluginSettings.instance();
        try {
            this.idr = ps.getDevice("dv.SWT");
            this.idr.setProperty("device.component", (Object)this);
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_139334_swt.createBarChart();
    }

    public void paintControl(PaintEvent e) {
        Rectangle d = this.getClientArea();
        Image imgChart = new Image((Device)this.getDisplay(), d);
        GC gcImage = new GC((Drawable)imgChart);
        this.idr.setProperty("device.output.context", (Object)gcImage);
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        if (this.bNeedsGeneration) {
            this.bNeedsGeneration = false;
            try {
                this.gcs = gr.build(this.idr.getDisplayServer(), this.cm, bo, null, null, null);
            }
            catch (ChartException ce) {
                ce.printStackTrace();
            }
        }
        try {
            gr.render(this.idr, this.gcs);
            GC gc = e.gc;
            gc.drawImage(imgChart, d.x, d.y);
        }
        catch (ChartException ce) {
            ce.printStackTrace();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(btn)) {
            int iSelection = cbType.getSelectionIndex();
            switch (iSelection) {
                case 0: {
                    this.cm = Regression_139334_swt.createBarChart();
                }
            }
            this.bNeedsGeneration = true;
            this.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.gcs.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.bNeedsGeneration = true;
        this.redraw();
    }

    public void repaintChart() {
        this.redraw();
    }

    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    public Object putContext(Object key, Object value) {
        return this.contextMap.put(key, value);
    }

    public Object removeContext(Object key) {
        return this.contextMap.remove(key);
    }

    public static final Chart createBarChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setType("Bar Chart");
        cwaBar.setSubType("Stacked");
        cwaBar.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaBar.getTitle().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)239, (int)33, (int)3), (LineStyle)LineStyle.DASH_DOTTED_LITERAL, (int)3));
        cwaBar.getTitle().setInsets(InsetsImpl.create((double)0.0, (double)10.0, (double)20.0, (double)10.0));
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        cwaBar.getPlot().getClientArea().getOutline().setVisible(false);
        cwaBar.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.MAX_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.MAX_LITERAL);
        DateTimeDataSet dsDateValues = DateTimeDataSetImpl.create((Object)new Calendar[]{new CDateTime(2004, 12, 27), new CDateTime(2004, 12, 23), new CDateTime(2004, 12, 22), new CDateTime(2004, 12, 21)});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsDateValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        BarSeries bs = (BarSeries)BarSeriesImpl.create();
        bs.setSeriesIdentifier((Object)"Actuate");
        bs.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        bs.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        bs.getLabel().setVisible(true);
        bs.setDataSet((DataSet)dsNumericValues1);
        bs.setStacked(true);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.BLUE());
        sdY.getSeries().add((Object)bs);
        return cwaBar;
    }
}

