/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_142685
extends ChartTestCase {
    private static String GOLDEN = "Regression_142685.jpg";
    private static String OUTPUT = "Regression_142685.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_142685();
    }

    public Regression_142685() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_142685.create3DLineChart();
        BufferedImage img = new BufferedImage(600, 600, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)600.0, (double)600.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void test_regression_142685() throws Exception {
        Regression_142685 st = new Regression_142685();
        Regression_142685.assertTrue((boolean)st.compareBytes(GOLDEN, OUTPUT));
    }

    public static final Chart create3DLineChart() {
        ChartWithAxes cwaLine = ChartWithAxesImpl.create();
        cwaLine.setType("Line Chart");
        cwaLine.setDimension(ChartDimension.THREE_DIMENSIONAL_LITERAL);
        cwaLine.setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.createY((double)0.0), Angle3DImpl.createX((double)-20.0)}));
        cwaLine.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaLine.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaLine).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaLine).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        Axis zAxisPrimary = AxisImpl.create((int)3);
        zAxisPrimary.setTitlePosition(Position.ABOVE_LITERAL);
        zAxisPrimary.getTitle().getCaption().setValue("Z Axis Title");
        zAxisPrimary.getTitle().setVisible(true);
        zAxisPrimary.setPrimaryAxis(true);
        FontDefinition fd1 = FontDefinitionImpl.create((String)"Arial", (float)10.0f, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)false, (double)10.0, (TextAlignment)TextAlignmentImpl.create());
        zAxisPrimary.getLabel().getCaption().setFont(fd1);
        zAxisPrimary.setLabelPosition(Position.ABOVE_LITERAL);
        zAxisPrimary.setOrientation(Orientation.HORIZONTAL_LITERAL);
        zAxisPrimary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        zAxisPrimary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
        zAxisPrimary.getTitle().setVisible(true);
        zAxisPrimary.setType(AxisType.TEXT_LITERAL);
        cwaLine.getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisPrimary);
        cwaLine.getPrimaryOrthogonalAxis(cwaLine.getPrimaryBaseAxes()[0]).getTitle().getCaption().getFont().setRotation(0.0);
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        NumberDataSet dsNumericValues2 = NumberDataSetImpl.create((Object)new double[]{15.29, -14.53, -47.05, 32.55});
        TextDataSet dsStringValue1 = TextDataSetImpl.create((Object)new String[]{"Actuate", "Microsoft"});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        LineSeries ls = (LineSeries)LineSeriesImpl.create();
        ls.setSeriesIdentifier((Object)"Actuate");
        ls.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        ls.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)207, (int)41, (int)207), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        ls.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        ls.getLabel().setVisible(true);
        ls.setDataSet((DataSet)dsNumericValues1);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.BLUE());
        sdY.getSeries().add((Object)ls);
        LineSeries ls2 = (LineSeries)LineSeriesImpl.create();
        ls2.setSeriesIdentifier((Object)"Micorsoft");
        ls2.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        ls2.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        ls2.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)122, (int)169, (int)168), (LineStyle)LineStyle.DOTTED_LITERAL, (int)1));
        ls2.getLabel().setVisible(true);
        ls2.setDataSet((DataSet)dsNumericValues2);
        SeriesDefinition sdY2 = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY2);
        sdY2.getSeriesPalette().update((Fill)ColorDefinitionImpl.PINK());
        sdY2.getSeries().add((Object)ls2);
        Series seZ = SeriesImpl.create();
        seZ.setDataSet((DataSet)dsStringValue1);
        SeriesDefinition sdZ = SeriesDefinitionImpl.create();
        sdZ.getSeriesPalette().update(0);
        sdZ.getSeries().add((Object)SeriesImpl.create());
        zAxisPrimary.getSeriesDefinitions().add((Object)sdZ);
        sdZ.getSeries().add((Object)seZ);
        return cwaLine;
    }
}

