/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ActionHandleTest
extends BaseTestCase {
    ActionHandle actionHandle = null;

    public ActionHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ActionHandleTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testTargetFileType() throws Exception {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        LibraryHandle library = this.sessionHandle.createLibrary();
        ElementFactory factory = new ElementFactory(library.getModule());
        ImageHandle image1 = factory.newImage("image1");
        ImageHandle image2 = factory.newImage("image2");
        LabelHandle label1 = factory.newLabel("label1");
        LabelHandle label2 = factory.newLabel("label2");
        library.getComponents().add((DesignElementHandle)image1);
        library.getComponents().add((DesignElementHandle)image2);
        library.getComponents().add((DesignElementHandle)label1);
        library.getComponents().add((DesignElementHandle)label2);
        Action action = StructureFactory.createAction();
        image1.setAction(action);
        image1.getActionHandle().setLinkType("hyperlink");
        image1.getActionHandle().setTargetBookmarkType("bookmark");
        ActionHandleTest.assertNull((Object)image1.getActionHandle().getTargetBookmarkType());
        action = StructureFactory.createAction();
        image2.setAction(action);
        image2.getActionHandle().setLinkType("bookmark-link");
        image2.getActionHandle().setTargetBookmarkType("toc");
        ActionHandleTest.assertEquals((String)"toc", (String)image2.getActionHandle().getTargetBookmarkType());
        action = StructureFactory.createAction();
        label1.setAction(action);
        label1.getActionHandle().setTargetFileType("report-design");
        ActionHandleTest.assertNotNull((Object)label1.getActionHandle().getTargetFileType());
        image1.getActionHandle().setLinkType("hyperlink");
        ActionHandleTest.assertEquals((String)"report-design", (String)label1.getActionHandle().getTargetFileType());
        library.getCommandStack().undo();
        ActionHandleTest.assertNull((Object)label1.getActionHandle().getTargetFileType());
        library.getCommandStack().redo();
        ActionHandleTest.assertEquals((String)"report-design", (String)label1.getActionHandle().getTargetFileType());
        action = StructureFactory.createAction();
        label2.setAction(action);
        label2.getActionHandle().setLinkType("drill-through");
        label2.getActionHandle().setTargetFileType("report-document");
        ActionHandleTest.assertEquals((String)"report-document", (String)label2.getActionHandle().getTargetFileType());
        label2.getActionHandle().setLinkType("bookmark-link");
        ActionHandleTest.assertNull((Object)label2.getActionHandle().getTargetFileType());
    }

    public void test_1() throws Exception {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        LibraryHandle library = this.sessionHandle.createLibrary();
        ElementFactory factory = new ElementFactory(library.getModule());
        ImageHandle image1 = factory.newImage("image1");
        ImageHandle image2 = factory.newImage("image2");
        LabelHandle label1 = factory.newLabel("label1");
        LabelHandle label2 = factory.newLabel("label2");
        library.getComponents().add((DesignElementHandle)image1);
        library.getComponents().add((DesignElementHandle)image2);
        library.getComponents().add((DesignElementHandle)label1);
        library.getComponents().add((DesignElementHandle)label2);
        Action action = StructureFactory.createAction();
        image1.setAction(action);
        image1.getActionHandle().setLinkType("hyperlink");
        image1.getActionHandle().setTargetBookmarkType("bookmark");
        ActionHandleTest.assertNull((Object)image1.getActionHandle().getTargetBookmarkType());
        action = StructureFactory.createAction();
        image2.setAction(action);
        image2.getActionHandle().setLinkType("bookmark-link");
        image2.getActionHandle().setTargetBookmarkType("toc");
        ActionHandleTest.assertEquals((String)"toc", (String)image2.getActionHandle().getTargetBookmarkType());
        action = StructureFactory.createAction();
        label1.setAction(action);
        label1.getActionHandle().setTargetFileType("report-design");
        ActionHandleTest.assertNotNull((Object)label1.getActionHandle().getTargetFileType());
        image1.getActionHandle().setLinkType("hyperlink");
        ActionHandleTest.assertEquals((String)"report-design", (String)label1.getActionHandle().getTargetFileType());
        library.getCommandStack().undo();
        ActionHandleTest.assertNull((Object)label1.getActionHandle().getTargetFileType());
        library.getCommandStack().redo();
        ActionHandleTest.assertEquals((String)"report-design", (String)label1.getActionHandle().getTargetFileType());
        action = StructureFactory.createAction();
        label2.setAction(action);
        label2.getActionHandle().setLinkType("drill-through");
        label2.getActionHandle().setTargetFileType("report-document");
        ActionHandleTest.assertEquals((String)"report-document", (String)label2.getActionHandle().getTargetFileType());
        label2.getActionHandle().setLinkType("bookmark-link");
        ActionHandleTest.assertNull((Object)label2.getActionHandle().getTargetFileType());
    }
}

