/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class EmbeddedImageHandleTest
extends BaseTestCase {
    String filename = "Improved_test6.xml";

    public EmbeddedImageHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EmbeddedImageHandleTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.filename);
    }

    public void testDrop() throws Exception {
        SessionHandle sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        ReportDesignHandle designHandle = sessionHandle.openDesign(String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + this.filename);
        PropertyHandle propHandle = designHandle.getPropertyHandle("images");
        EmbeddedImageHandle image1handle = (EmbeddedImageHandle)designHandle.findImage("group confirmation logo.jpg").getHandle((SimpleValueHandle)propHandle);
        EmbeddedImageHandle image2handle = (EmbeddedImageHandle)designHandle.findImage("circles.png").getHandle((SimpleValueHandle)propHandle);
        image1handle.drop();
        ArrayList value = propHandle.getListValue();
        EmbeddedImageHandleTest.assertEquals((int)1, (int)value.size());
        EmbeddedImageHandleTest.assertEquals((Object)image2handle.getStructure(), value.get(0));
        EmbeddedImageHandleTest.assertNull((Object)image1handle.getStructure());
        image2handle.drop();
        ArrayList value1 = propHandle.getListValue();
        EmbeddedImageHandleTest.assertEquals((int)0, (int)value1.size());
        EmbeddedImageHandleTest.assertNull((Object)image2handle.getStructure());
    }
}

