/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class LibraryIncludeLibraryTest
extends BaseTestCase {
    private String inputLibraryName1 = "Library_ElementID_Lib.xml";
    private String inputLibraryName2 = "LibraryCreatLib.xml";
    private String goldenFileName = "Library_IncludeLibrary_Lib_golden.xml";
    private String outputFileName = "Library_IncludeLibrary_Lib.xml";

    public LibraryIncludeLibraryTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LibraryIncludeLibraryTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.inputLibraryName1);
        this.copyInputToFile("input/" + this.inputLibraryName2);
        this.copyGoldenToFile("golden/" + this.goldenFileName);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testIncludeLibrary() throws Exception {
        this.openLibrary(this.inputLibraryName2);
        this.libraryHandle.includeLibrary(this.inputLibraryName1, "LibA");
        LibraryHandle libHandle = this.libraryHandle.getLibrary("LibA");
        TableHandle tableLibHandle = (TableHandle)libHandle.findElement("tableA");
        LibraryIncludeLibraryTest.assertNotNull((String)"Table should not be null", (Object)tableLibHandle);
        DataSourceHandle dataSourceLibHandle = libHandle.findDataSource("mysql");
        LibraryIncludeLibraryTest.assertNotNull((String)"Datasource should not be null", (Object)dataSourceLibHandle);
        DataSetHandle dataSetLibHandle = libHandle.findDataSet("mysqlds");
        LibraryIncludeLibraryTest.assertNotNull((String)"Dataset should not be null", (Object)dataSetLibHandle);
        TableHandle cfr_ignored_0 = (TableHandle)this.libraryHandle.getElementFactory().newElementFrom((DesignElementHandle)tableLibHandle, "tableA");
        OdaDataSourceHandle dataSourceHandle = this.libraryHandle.getElementFactory().newOdaDataSource("mysql");
        OdaDataSetHandle dataSetHandle = this.libraryHandle.getElementFactory().newOdaDataSet("mysqlds");
        this.libraryHandle.getDataSources().add((DesignElementHandle)dataSourceHandle);
        this.libraryHandle.getDataSets().add((DesignElementHandle)dataSetHandle);
        LibraryIncludeLibraryTest.assertNotNull((Object)this.libraryHandle);
        String TempFile = this.genOutputFile(this.outputFileName);
        this.libraryHandle.saveAs(TempFile);
        LibraryIncludeLibraryTest.assertTrue((boolean)this.compareTextFile(this.goldenFileName, this.outputFileName));
    }
}

