/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ReportItemHandleTest
extends BaseTestCase {
    DesignElement element;
    InnerReportItemHandle innerHandle;

    public ReportItemHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ReportItemHandleTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT("ReportItemHandleTest.xml", "ReportItemHandleTest.xml");
        this.openDesign("ReportItemHandleTest.xml");
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testACL() throws SemanticException {
        TextItemHandle textHandle = (TextItemHandle)this.designHandle.findElement("myText");
        String aclExp = "rule1:root";
        textHandle.setACLExpression(aclExp);
        ReportItemHandleTest.assertEquals((String)aclExp, (String)textHandle.getACLExpression());
        ReportItemHandleTest.assertFalse((boolean)textHandle.cascadeACL());
        textHandle.setCascadeACL(true);
        ReportItemHandleTest.assertFalse((boolean)textHandle.cascadeACL());
        ReportItemHandleTest.assertFalse((boolean)((Boolean)textHandle.getProperty("cascadeACL")));
        aclExp = "sid1,sid2";
        textHandle.setACLExpression(aclExp);
        ReportItemHandleTest.assertEquals((String)aclExp, (String)textHandle.getACLExpression());
        aclExp = "\u666e\u901a\u7528\u6237~!@#$%^&*()_+=-`{}|:;.?'";
        textHandle.setACLExpression(aclExp);
        ReportItemHandleTest.assertEquals((String)aclExp, (String)textHandle.getACLExpression());
        aclExp = " ";
        textHandle.setACLExpression(aclExp);
        ReportItemHandleTest.assertEquals((String)aclExp, (String)textHandle.getACLExpression());
    }

    class InnerReportItemHandle
    extends ReportItemHandle {
        InnerReportItemHandle(ReportDesign design, DesignElement element) {
            super((Module)design, element);
        }
    }
}

