/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_122213
extends BaseTestCase {
    private static final String REPORT = "regression_122213.xml";
    private static final String libname1 = "regression_122213_lib1.xml";
    private static final String libname2 = "regression_122213_lib2.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(REPORT, REPORT);
        this.copyResource_INPUT(libname1, libname1);
        this.copyResource_INPUT(libname2, libname2);
    }

    public void test_regression_122213() throws DesignFileException {
        this.openDesign(REPORT);
        List libs = this.designHandle.getLibraries();
        Regression_122213.assertEquals((int)1, (int)libs.size());
        LibraryHandle includeLib = (LibraryHandle)libs.get(0);
        Regression_122213.assertEquals((int)2, (int)includeLib.getThemes().getCount());
        LibraryHandle lib2 = includeLib.getLibrary("regression_122213_lib1");
        List lib2Themes = lib2.getThemes().getContents();
        Regression_122213.assertEquals((int)2, (int)lib2Themes.size());
        List themes = this.designHandle.getVisibleThemes(1);
        Regression_122213.assertEquals((String)"regression_122213_lib2.defaultTheme", (String)((ThemeHandle)themes.get(0)).getQualifiedName());
        Regression_122213.assertEquals((String)"regression_122213_lib2.t2", (String)((ThemeHandle)themes.get(1)).getQualifiedName());
        Regression_122213.assertEquals((int)2, (int)themes.size());
        Regression_122213.assertFalse((boolean)themes.contains(lib2Themes.get(0)));
        Regression_122213.assertFalse((boolean)themes.contains(lib2Themes.get(1)));
    }
}

