/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_130271
extends BaseTestCase {
    private static final String INPUT = "Reg_130271.xml";
    private static final String LIBRARY = "Reg_130271_lib.xml";
    private static final String OUTPUT = "Reg_130271_out.xml";
    private static final String GOLDEN = "Reg_130271_golden.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/Reg_130271.xml");
        this.copyInputToFile("input/Reg_130271_lib.xml");
        this.copyGoldenToFile("golden/Reg_130271_golden.xml");
    }

    public void test_regression_130271() throws Exception {
        this.openLibrary(LIBRARY);
        DataSourceHandle datasource = this.libraryHandle.findDataSource("Data Source");
        DataSetHandle dataset = this.libraryHandle.findDataSet("Data Set");
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        this.designHandle = this.sessionHandle.createDesign();
        this.openDesign(INPUT);
        this.designHandle.includeLibrary(LIBRARY, "lib");
        DataSourceHandle dsource = (DataSourceHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)datasource, "dsource");
        DataSetHandle dset = (DataSetHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)dataset, "dset");
        this.designHandle.getDataSources().add((DesignElementHandle)dsource);
        this.designHandle.getDataSets().add((DesignElementHandle)dset);
        String TempFile = this.genOutputFile(OUTPUT);
        this.designHandle.saveAs(TempFile);
        Regression_130271.assertTrue((boolean)super.compareTextFile(GOLDEN, OUTPUT));
    }
}

